/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.ohaotian.plugin.base.exception.ResourceException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TkHttpRequestUtils {
    private static String realConn(String charset, String content, Map<String, String> header, String url, Integer connectTimeout, Integer socketTimeout, String contentType) {
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = "UTF-8";
        }
        if (null == connectTimeout) {
            connectTimeout = 3000;
        }
        if (null == socketTimeout) {
            socketTimeout = 3000;
        }
        FilterOutputStream out = null;
        InputStream is = null;
        try {
            int statusCode;
            URL console = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)console.openConnection(Proxy.NO_PROXY);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(socketTimeout);
            conn.setDoOutput(true);
            if (null != header) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isBlank((CharSequence)contentType)) {
                conn.setRequestProperty("Content-Type", "application/json; charset=" + charset);
            } else {
                conn.setRequestProperty("Content-Type", contentType + "; charset=" + charset);
            }
            conn.connect();
            if (StringUtils.isNotBlank((CharSequence)content)) {
                out = new DataOutputStream(conn.getOutputStream());
                out.write(content.getBytes(charset));
                ((DataOutputStream)out).flush();
            }
            if (200 != (statusCode = conn.getResponseCode())) {
                Map.Entry<String, String> entry;
                entry = null;
                return entry;
            }
            is = conn.getInputStream();
            if (null != is) {
                String rspStr;
                int len;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                String string = rspStr = new String(outStream.toByteArray(), charset);
                return string;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ResourceException("9999", e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new ResourceException("9999", e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String conn(String charset, String content, Map<String, String> header, String url, Integer connectTimeout, Integer socketTimeout) {
        return TkHttpRequestUtils.realConn(charset, content, header, url, connectTimeout, socketTimeout, null);
    }

    public static String conn(String charset, String content, Map<String, String> header, String url, Integer connectTimeout, Integer socketTimeout, String contentType) {
        return TkHttpRequestUtils.realConn(charset, content, header, url, connectTimeout, socketTimeout, contentType);
    }
}

