/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);

    public static String getHostAddress() {
        InetAddress localHost = IpUtil.getLocalHostExactAddress();
        return localHost.getHostAddress();
    }

    public static InetAddress getLocalHostExactAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> nias = ni.getInetAddresses();
                while (nias.hasMoreElements()) {
                    InetAddress ia = nias.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia;
                }
            }
        }
        catch (SocketException var5) {
            var5.printStackTrace();
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException var4) {
                var4.printStackTrace();
            }
        }
        return null;
    }

    public static String getMinIOAddress() {
        try {
            InetAddress minioAddress = InetAddress.getByName("minio");
            if (minioAddress == null) {
                throw new Exception("minio host is null");
            }
            return minioAddress.getHostAddress();
        }
        catch (Exception var1) {
            System.out.println("not minio host");
            return IpUtil.getHostAddress();
        }
    }
}

