/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKFileUtils {
    private static final Logger log = LoggerFactory.getLogger(TKFileUtils.class);

    public static void writeBytesToFile(byte[] bs, String path) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        ByteArrayInputStream is = new ByteArrayInputStream(bs);
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = is.read(buff)) != -1) {
            ((OutputStream)out).write(buff, 0, len);
        }
        ((InputStream)is).close();
        ((OutputStream)out).close();
    }

    public static byte[] strToByteArray(String str) {
        if (str == null) {
            return null;
        }
        byte[] byteArray = str.getBytes();
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(String filePath) {
        FileInputStream stream = null;
        ByteArrayOutputStream out = null;
        File f = new File(filePath);
        if (!f.exists() || !f.isFile()) {
            return null;
        }
        try {
            int n;
            stream = new FileInputStream(f);
            out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File f) {
        FileInputStream stream = null;
        ByteArrayOutputStream out = null;
        if (!f.exists() || !f.isFile()) {
            return null;
        }
        try {
            int n;
            stream = new FileInputStream(f);
            out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static FilenameFilter filter(final String regex) {
        return new FilenameFilter(){
            private Pattern pattern;
            {
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.pattern.matcher(name).matches();
            }
        };
    }

    public static File[] getFilesByPattern(String pattern, File file) {
        File[] list = StringUtils.isBlank((CharSequence)pattern) ? file.listFiles() : file.listFiles(TKFileUtils.filter(pattern));
        return list;
    }

    public static void write(String filePath, String fileContent) {
        try {
            FileOutputStream fo = new FileOutputStream(filePath);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fo, "UTF-8");
            out.write(fileContent);
            out.close();
        }
        catch (IOException ex) {
            log.error("\u628a\u5185\u5bb9\u5199\u5165\u6587\u4ef6" + filePath + "\u5931\u8d25:" + ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static void appendFile(String file, String conent) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
            out.write(conent + "\r\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Date getCreateTime(String fullFileName) {
        Path path = Paths.get(fullFileName, new String[0]);
        BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            BasicFileAttributes attr = basicview.readAttributes();
            Date createDate = new Date(attr.creationTime().toMillis());
            return createDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            Calendar cal = Calendar.getInstance();
            cal.set(1970, 0, 1, 0, 0, 0);
            return cal.getTime();
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(TKFileUtils.getCreateTime("D:\\hsf\\taobao-tomcat-7.0.59\\logs\\restcontroller.out"));
    }
}

