/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import io.minio.MinioClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.xml.bind.DatatypeConverter;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MinIOUntil {
    private static final Logger log = LoggerFactory.getLogger(MinIOUntil.class);
    @Value(value="${minio.endpoint:}")
    private String endpoint;
    @Value(value="${minio.accesskey:}")
    private String accesskey;
    @Value(value="${minio.secretkey:}")
    private String secretkey;
    private static String bucketname;
    private static MinioClient minioClient;

    @Value(value="${minio.bucketname:}")
    public void setBuketName(String bucketName) {
        bucketname = bucketName;
    }

    @PostConstruct
    private void init() {
    }

    public static String uploadFile(String base64, String fileName, String extName, String path, String bucketName) {
        try {
            byte[] fileByte = DatatypeConverter.parseBase64Binary((String)base64);
            MagicMatch match = Magic.getMagicMatch((byte[])fileByte);
            return MinIOUntil.uploadFile(new ByteArrayInputStream(fileByte), fileName, extName, path, bucketName, match.getMimeType());
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static String uploadFile(String base64, String path) {
        try {
            byte[] fileByte = DatatypeConverter.parseBase64Binary((String)base64);
            MagicMatch match = Magic.getMagicMatch((byte[])fileByte);
            return MinIOUntil.uploadFile(new ByteArrayInputStream(fileByte), null, null, path, null, match.getMimeType());
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static String uploadFile(byte[] fileByte, String fileName, String extName, String path, String bucketName) {
        try {
            MagicMatch match = Magic.getMagicMatch((byte[])fileByte);
            return MinIOUntil.uploadFile(new ByteArrayInputStream(fileByte), fileName, extName, path, bucketName, match.getMimeType());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\uff0c\u83b7\u53d6\u7c7b\u578b\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static String uploadFile(InputStream file, String fileName, String extName, String path, String bucketName, String type) {
        String url;
        if (StringUtils.isBlank((String)bucketName)) {
            bucketName = bucketname;
        }
        try {
            if (!minioClient.bucketExists(bucketName)) {
                minioClient.makeBucket(bucketName);
            }
            if (StringUtils.isBlank((String)fileName)) {
                fileName = UUID.randomUUID().toString();
            }
            if (StringUtils.isBlank((String)extName)) {
                extName = ".jpg";
            }
            if (StringUtils.isBlank((String)path)) {
                path = "temp/";
            }
            minioClient.putObject(bucketName, path + fileName + extName, file, type);
            file.close();
            url = minioClient.getObjectUrl(bucketName, path + fileName + extName);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01" + e.getMessage());
        }
        return url;
    }

    static {
        minioClient = null;
    }
}

