/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.tydic.newretail.toolkit.atom.TkConsumerService;
import com.tydic.newretail.toolkit.util.TkSpringBeanUtils;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class TkConsumerUtil
implements ApplicationListener<ContextRefreshedEvent> {
    private static Logger log = LoggerFactory.getLogger(TkConsumerUtil.class);
    private static Consumer consumer;
    private static Properties propertiesFileLoader;
    private static String TK_GID;
    private static String TK_TOPIC;
    private static String ACCESS_KEY;
    private static String SECRET_KEY;
    private static String ONS_ADDR;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        log.info("\u542f\u52a8\u52a0\u8f7d\u6d88\u8d39\u8005----");
        if (contextRefreshedEvent.getApplicationContext().getParent() == null) {
            try {
                this.initConfig(contextRefreshedEvent.getApplicationContext());
                if (StringUtils.isBlank((CharSequence)TK_GID) || StringUtils.isBlank((CharSequence)TK_TOPIC) || StringUtils.isBlank((CharSequence)ACCESS_KEY) || StringUtils.isBlank((CharSequence)SECRET_KEY) || StringUtils.isBlank((CharSequence)ONS_ADDR)) {
                    log.error("\u6d88\u8d39\u8005\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5e94\u914d\u7f6e");
                    return;
                }
                Properties properties = new Properties();
                properties.put("GROUP_ID", TK_GID);
                properties.put("ConsumerId", TK_GID);
                properties.put("AccessKey", ACCESS_KEY);
                properties.put("SecretKey", SECRET_KEY);
                properties.put("ONSAddr", ONS_ADDR);
                consumer = ONSFactory.createConsumer((Properties)properties);
                consumer.subscribe(TK_TOPIC, "*", new MessageListener(){

                    public Action consume(Message message, ConsumeContext context) {
                        log.info("\u6536\u5230\u6d88\u606f----");
                        try {
                            Map map = TkSpringBeanUtils.getApplicationContext().getBeansOfType(TkConsumerService.class);
                            if (MapUtils.isEmpty((Map)map)) {
                                log.error("\u672a\u627e\u5230\u6d88\u8d39\u8005");
                                return Action.CommitMessage;
                            }
                            for (TkConsumerService tkConsumerService : map.values()) {
                                tkConsumerService.execute(message.getTag(), TkConsumerUtil.deserialize(message.getBody()).toString());
                            }
                        }
                        catch (Exception e) {
                            log.error("\u6d88\u8d39\u8005\u6d88\u8d39\u5f02\u5e38\uff1a" + e.getMessage());
                            return Action.CommitMessage;
                        }
                        return Action.CommitMessage;
                    }
                });
                consumer.start();
            }
            catch (Exception e) {
                log.error("\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    private void initConfig(ApplicationContext applicationContext) {
        Object bean = applicationContext.getBean("propertiesFileLoader");
        if (null == bean) {
            log.error("propertiesFileLoader\u6ce8\u5165\u5931\u8d25");
            return;
        }
        propertiesFileLoader = (Properties)bean;
        TK_GID = propertiesFileLoader.getProperty("BUY_COMM_GID");
        TK_TOPIC = propertiesFileLoader.getProperty("BUY_COMM_TOPIC");
        ACCESS_KEY = propertiesFileLoader.getProperty("mq.accessKey");
        SECRET_KEY = propertiesFileLoader.getProperty("mq.secretKey");
        ONS_ADDR = propertiesFileLoader.getProperty("mq.onsAddr");
        if (StringUtils.isBlank((CharSequence)TK_GID)) {
            log.error("\u672a\u83b7\u53d6GID\uff1amq.gid");
            return;
        }
        if (StringUtils.isBlank((CharSequence)TK_TOPIC)) {
            log.error("\u672a\u83b7\u53d6TOPIC\uff1amq.topic");
            return;
        }
        if (StringUtils.isBlank((CharSequence)ACCESS_KEY) || StringUtils.isBlank((CharSequence)SECRET_KEY) || StringUtils.isBlank((CharSequence)ONS_ADDR)) {
            log.error("\u672a\u83b7\u53d6\u5230ONS\u76f8\u5173\u914d\u7f6e\uff1amq.accessKey | mq.secretKey | mq.onsAddr");
            return;
        }
    }

    public static Object deserialize(byte[] bytes) {
        Object result = null;
        if (TkConsumerUtil.isEmpty(bytes)) {
            return null;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
                try {
                    result = objectInputStream.readObject();
                }
                catch (ClassNotFoundException var5) {
                    throw new Exception("Failed to deserialize object type", var5);
                }
            }
            catch (Throwable var6) {
                throw new Exception("Failed to deserialize", var6);
            }
        }
        catch (Exception var7) {
            log.error("Failed to deserialize", (Throwable)var7);
        }
        return result;
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    static {
        TK_GID = null;
        TK_TOPIC = null;
        ACCESS_KEY = null;
        SECRET_KEY = null;
        ONS_ADDR = null;
    }
}

