/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.tydic.newretail.toolkit.util.Point;

public class TransUtil {
    public static double getAngle(Point p1, Point p2) {
        double angle = Math.atan2(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return angle * 57.29577951308232;
    }

    public static double getScale(Point p1, Point b1, Point p2, Point b2) {
        return TransUtil.getLength(b1, b2) / TransUtil.getLength(p1, p2);
    }

    public static double getLength(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
    }

    public static double getXTranslation(Point p1, Point b1, double rotation, double scale) {
        return b1.getX() - scale * (p1.getX() * Math.cos(rotation) - p1.getY() * Math.sin(rotation));
    }

    public static double getYTranslation(Point p1, Point b1, double rotation, double scale) {
        return b1.getY() - scale * (p1.getX() * Math.sin(rotation) + p1.getY() * Math.cos(rotation));
    }

    public static Point transformBoePoint(Point gp, double rotation, double scale, double dx, double dy) {
        double A = scale * Math.cos(rotation);
        double B = scale * Math.sin(rotation);
        return new Point(TransUtil.retain6(A * gp.getX() - B * gp.getY() + dx), TransUtil.retain6(B * gp.getX() + A * gp.getY() + dy), 0.0);
    }

    public static double retain6(double num) {
        String result = String.format("%.6f", num);
        return Double.valueOf(result);
    }

    public static void main(String[] args) {
        Point Point1 = new Point(1.0, 4.0, 0.0);
        Point Point2 = new Point(4.0, 1.0, 0.0);
        Point newPoint1 = new Point(1.0, 2.0, 0.0);
        Point newPoint2 = new Point(2.0, 1.0, 0.0);
        double rotation = Math.toRadians(Math.abs(TransUtil.getAngle(Point1, Point2) - TransUtil.getAngle(newPoint1, newPoint2)));
        double scale = TransUtil.getScale(Point1, newPoint1, Point2, newPoint2);
        double tx = TransUtil.getXTranslation(Point1, newPoint1, rotation, scale);
        double ty = TransUtil.getYTranslation(Point1, newPoint1, rotation, scale);
        Point transPoint = new Point(2.5, 1.0, 0.0);
        Point resultPoint = TransUtil.transformBoePoint(transPoint, rotation, scale, tx, ty);
        System.out.println(rotation);
        System.out.println(scale);
        System.out.println(tx);
        System.out.println(ty);
        System.out.println(resultPoint.toString());
    }
}

