/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.tydic.newretail.toolkit.thread.WriteRestLogsThread;
import javax.xml.bind.DatatypeConverter;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDFSClientUtil {
    private static final Logger log = LoggerFactory.getLogger(WriteRestLogsThread.class);
    private static final String CONFIG_FILENAME = "fdfs_client.conf";
    private static StorageClient storageClient;

    public static String uploadFile(byte[] fileContent, String extName) {
        try {
            String[] file = storageClient.upload_file(fileContent, extName, null);
            return file[0] + "/" + file[1];
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static String uploadFile(byte[] fileContent) {
        try {
            String[] file = storageClient.upload_file(fileContent, "jpg", null);
            return file[0] + "/" + file[1];
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static String uploadFile(String base64Content) {
        try {
            String[] file = storageClient.upload_file(DatatypeConverter.parseBase64Binary((String)base64Content), "jpg", null);
            return file[0] + "/" + file[1];
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static String uploadFile(String base64Content, String extName) {
        try {
            String[] file = storageClient.upload_file(DatatypeConverter.parseBase64Binary((String)base64Content), extName, null);
            return file[0] + "/" + file[1];
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static byte[] downloadFile(String groupName, String fileId) {
        try {
            byte[] fileByte = storageClient.download_file(groupName, fileId);
            return fileByte;
        }
        catch (Exception e) {
            log.error("" + groupName + "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static int deleteFile(String groupName, String remoteFilename) {
        try {
            int i = storageClient.delete_file(groupName, remoteFilename);
            log.info("delete file successfully!!!" + i);
            return 1;
        }
        catch (Exception e) {
            log.error("" + remoteFilename + "\u5220\u9664\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            return 0;
        }
    }

    static {
        try {
            ClientGlobal.init((String)CONFIG_FILENAME);
            TrackerClient trackerClient = new TrackerClient();
            TrackerServer trackerServer = trackerClient.getConnection();
            StorageServer storageServer = trackerClient.getStoreStorage(trackerServer);
            storageClient = new StorageClient(trackerServer, storageServer);
            log.info("\u521d\u59cb\u5316 Fastdfs Client \u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)ClientGlobal.configInfo());
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }
}

