/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TkDateUtils {
    public static final String MMDD = "MM-dd";
    public static final String MMDDHHMM = "MM-dd HH:mm";
    public static final String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDD = "yyyy-MM-dd";
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String yyyyMMddHH = "yyyyMMddHH";
    public static final String yyyyMMddHHmm = "yyyyMMddHHmm";
    public static final String SPLICE_TYPE_YEAR = "YYYY";
    public static final String SPLICE_TYPE_MONTH = "YYYY-MM";
    public static final String SPLICE_TYPE_WEEK = "WW";
    public static final String SPLICE_TYPE_DAY = "MM-dd";
    public static final String SPLICE_TYPE_HOUR = "HH:mm";

    public static boolean belongCalendar(Date nowTime, Date beginTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.after(begin) && date.before(end)) {
            return true;
        }
        return nowTime.compareTo(beginTime) == 0 || nowTime.compareTo(endTime) == 0;
    }

    public static Date getWeeHours(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zero = calendar.getTime();
        return zero;
    }

    public static Date formatDateStrToDate(String strDate, String formatStr) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(formatStr);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static String formatDate(Date date, String formatStr) {
        SimpleDateFormat formatDate = new SimpleDateFormat(formatStr);
        String resultTime = formatDate.format(date);
        return resultTime;
    }

    public static String dateToDatetimeStr(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(YYYYMMDDHHMMSS);
        String dataStr = format.format((Object)date);
        return dataStr;
    }

    public static String dateToDateStr(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(YYYYMMDD);
        String dataStr = format.format((Object)date);
        return dataStr;
    }

    public static Date datetimeStrToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMMDDHHMMSS);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static Date dateStrToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMMDD);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static Date getDate(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (days != null) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static int diffDay(Date start, Date end) {
        int days = (int)((end.getTime() - start.getTime()) / 86400000L);
        return days;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static boolean validateDate(Date createDate, Date now) {
        Calendar createCal = Calendar.getInstance();
        createCal.setTime(createDate);
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(now);
        int createYear = createCal.get(1);
        int nowYear = nowCal.get(1);
        int createMonth = createCal.get(2) + 1;
        int nowMonth = nowCal.get(2) + 1;
        int createDay = createCal.get(5);
        int nowDay = nowCal.get(5);
        return nowYear - createYear > 0 || nowMonth - createMonth > 0 || nowDay - createDay > 0;
    }

    public static List<String> sliceTimeByType(Date startTime, Date endTime, String type) {
        if (SPLICE_TYPE_WEEK.equals(type)) {
            return TkDateUtils.getWeeks(startTime, endTime);
        }
        ArrayList<String> result = new ArrayList<String>();
        List<DateTime> dateTimes = TkDateUtils.getDateTimes(startTime, endTime, type);
        for (DateTime dateTime : dateTimes) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(type);
            String time = simpleDateFormat.format(dateTime.toJdkDate());
            result.add(time);
        }
        return result;
    }

    public static Map<String, Integer> sliceTimeMapByType(Date startTime, Date endTime, String type) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        if (SPLICE_TYPE_WEEK.equals(type)) {
            List<String> resultList = TkDateUtils.getWeeks(startTime, endTime);
            for (String str : resultList) {
                result.put(str, 0);
            }
            return result;
        }
        List<DateTime> dateTimes = TkDateUtils.getDateTimes(startTime, endTime, type);
        for (DateTime dateTime : dateTimes) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(type);
            String time = simpleDateFormat.format(dateTime.toJdkDate());
            result.put(time, 0);
        }
        return result;
    }

    private static List<DateTime> getDateTimes(Date startTime, Date endTime, String type) {
        DateField field;
        DateTime startDateTime = DateUtil.date((Date)startTime);
        DateTime endDateTime = DateUtil.date((Date)endTime);
        switch (type) {
            case "YYYY": {
                field = DateField.YEAR;
                break;
            }
            case "YYYY-MM": {
                field = DateField.MONTH;
                break;
            }
            case "WW": {
                field = DateField.WEEK_OF_YEAR;
                break;
            }
            case "MM-dd": {
                field = DateField.DAY_OF_YEAR;
                break;
            }
            case "HH:mm": {
                field = DateField.HOUR_OF_DAY;
                break;
            }
            default: {
                return new ArrayList<DateTime>();
            }
        }
        return DateUtil.rangeToList((Date)startDateTime, (Date)endDateTime, (DateField)field);
    }

    private static List<String> getWeeks(Date startTime, Date endTime) {
        List<String> result = new ArrayList<String>();
        if (DateUtil.year((Date)startTime) != DateUtil.year((Date)endTime)) {
            int i;
            if (DateUtil.weekOfYear((Date)startTime) == 1) {
                result.add(String.valueOf(0));
            } else {
                for (i = DateUtil.weekOfYear((Date)startTime); i <= 52; ++i) {
                    result.add(String.valueOf(i - 1));
                }
            }
            for (i = 1; i <= DateUtil.weekOfYear((Date)endTime); ++i) {
                result.add(String.valueOf(i - 1));
            }
        } else {
            for (int i = DateUtil.weekOfYear((Date)startTime); i <= DateUtil.weekOfYear((Date)endTime); ++i) {
                result.add(String.valueOf(i - 1));
            }
        }
        if (result.size() == 5) {
            result = result.subList(1, result.size());
        }
        return result;
    }

    public static boolean validateTime(Date startTime, Date endTime) {
        if (TkDateUtils.validateDate(startTime, endTime)) {
            return false;
        }
        Calendar createCal = Calendar.getInstance();
        createCal.setTime(startTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endTime);
        int createHour = createCal.get(11);
        int createMinute = createCal.get(12);
        int createSecond = createCal.get(13);
        int endHour = endCal.get(11);
        int endMinute = endCal.get(12);
        int endSecond = endCal.get(13);
        return endHour - createHour > 0 || endMinute - createMinute > 0 || endSecond - createSecond > 0;
    }

    public static String getEndDayOfWeekNo(int year, int weekNo) {
        Calendar cal = TkDateUtils.getCalendarFormYear(year);
        cal.set(3, weekNo);
        cal.add(7, 6);
        return cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
    }

    private static Calendar getCalendarFormYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(1, year);
        return cal;
    }

    public static String getStartDayOfWeekNo(int year, int weekNo) {
        Calendar cal = TkDateUtils.getCalendarFormYear(year);
        cal.set(3, weekNo);
        return cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
    }

    public static Date addMinuteToDate(int minute, Date dateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static int getZeroDiff() {
        Date date = new Date();
        long nowSeconds = date.getTime();
        Date weeHours = TkDateUtils.getWeeHours(TkDateUtils.getDate(date, 1));
        long zeroSeconds = weeHours.getTime();
        int diffSeconds = (int)(zeroSeconds - nowSeconds) / 1000 - 1;
        return diffSeconds;
    }

    public static void main(String[] args) {
        System.out.println(TkDateUtils.isEffectiveDate(new Date(), TkDateUtils.formatDateStrToDate("2019-08-01 00:00:00", YYYYMMDDHHMMSS), TkDateUtils.formatDateStrToDate("2019-08-29 22:59:59", YYYYMMDDHHMMSS)));
        System.out.println(TkDateUtils.validateDate(DateUtils.strToDateLong((String)"2020-11-27 19:18:10"), new Date()));
        String dateDate = TkDateUtils.dateToDateStr(new Date());
        System.out.println(TkDateUtils.sliceTimeMapByType(TkDateUtils.datetimeStrToDate(dateDate + " 08:00:00"), TkDateUtils.datetimeStrToDate(dateDate + " 18:00:00"), SPLICE_TYPE_HOUR));
        Date date = TkDateUtils.getDate(new Date(), 1);
        Date now = new Date();
        Date weeHours = TkDateUtils.getWeeHours(date);
        System.out.println(weeHours);
        long l = (weeHours.getTime() - now.getTime()) / 1000L;
        System.out.println(l);
        System.out.println(TkDateUtils.sliceTimeByType(TkDateUtils.datetimeStrToDate("2020-12-26 19:18:10"), TkDateUtils.datetimeStrToDate("2021-01-01 19:18:10"), SPLICE_TYPE_WEEK));
        System.out.println(DateUtil.weekOfYear((Date)TkDateUtils.datetimeStrToDate("2021-01-01 19:18:10")));
        System.out.println(DateUtil.weekOfYear((Date)TkDateUtils.datetimeStrToDate("2020-12-26 19:18:10")));
        System.out.println(DateUtil.weekOfYear((Date)TkDateUtils.datetimeStrToDate("2020-12-28 19:18:10")));
    }
}

