/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import java.util.BitSet;
import java.util.HashMap;

public class TkGeoHashUtils {
    private static int numbits = 30;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final HashMap<Character, Integer> lookup = new HashMap();
    private static final double EARTH_RADIUS = 6371000.0;

    public static double[] decode(String geohash) {
        boolean isSet;
        int i;
        StringBuilder buffer = new StringBuilder();
        for (char c : geohash.toCharArray()) {
            int i2 = lookup.get(Character.valueOf(c)) + 32;
            buffer.append(Integer.toString(i2, 2).substring(1));
        }
        BitSet lonset = new BitSet();
        BitSet latset = new BitSet();
        int j = 0;
        for (i = 0; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            lonset.set(j++, isSet);
        }
        j = 0;
        for (i = 1; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            latset.set(j++, isSet);
        }
        double lon = TkGeoHashUtils.decode(lonset, 70.0, 140.0);
        double lat = TkGeoHashUtils.decode(latset, 0.0, 60.0);
        return new double[]{lat, lon};
    }

    private static double decode(BitSet bs, double floor, double ceiling) {
        double mid = 0.0;
        for (int i = 0; i < bs.length(); ++i) {
            mid = (floor + ceiling) / 2.0;
            if (bs.get(i)) {
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return mid;
    }

    public static String encode(double lat, double lon) {
        BitSet latbits = TkGeoHashUtils.getBits(lat, 0.0, 60.0);
        BitSet lonbits = TkGeoHashUtils.getBits(lon, 70.0, 140.0);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numbits; ++i) {
            buffer.append(lonbits.get(i) ? (char)'1' : '0');
            buffer.append(latbits.get(i) ? (char)'1' : '0');
        }
        return TkGeoHashUtils.base32(Long.parseLong(buffer.toString(), 2));
    }

    private static BitSet getBits(double lat, double floor, double ceiling) {
        BitSet buffer = new BitSet(numbits);
        for (int i = 0; i < numbits; ++i) {
            double mid = (floor + ceiling) / 2.0;
            if (lat >= mid) {
                buffer.set(i);
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return buffer;
    }

    public static String base32(long i) {
        boolean negative;
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -32L) {
            buf[charPos--] = digits[(int)(-(i % 32L))];
            i /= 32L;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = TkGeoHashUtils.rad(lat1);
        double radLat2 = TkGeoHashUtils.rad(lat2);
        double a = radLat1 - radLat2;
        double b = TkGeoHashUtils.rad(lon1) - TkGeoHashUtils.rad(lon2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6371000.0;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    public static void main(String[] args) {
    }

    static {
        int i = 0;
        for (char c : digits) {
            lookup.put(Character.valueOf(c), i++);
        }
    }
}

