/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.atom.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.dao.EscapeCodeDao;
import com.tydic.newretail.toolkit.dao.po.EscapeCodePO;
import com.tydic.newretail.toolkit.util.EscapeCodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class QryEscapeAtomServiceImpl
implements QryEscapeAtomService,
ApplicationListener<ContextRefreshedEvent> {
    private EscapeCodeDao escapeCodeDao;
    private CacheClient cacheClient;

    @Override
    public String getCodeTitle(String parentCode, String code) {
        return EscapeCodeUtils.getCodeTitle(this.escapeCodeDao, parentCode, code);
    }

    @Override
    public List<QryEscapeBO> listEscapeByParentCode(String parentCode) {
        List<EscapeCodePO> pos = EscapeCodeUtils.listEscapeByParentCode(this.escapeCodeDao, parentCode);
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<QryEscapeBO> rspList = new ArrayList<QryEscapeBO>(pos.size());
        for (EscapeCodePO po : pos) {
            QryEscapeBO bo = new QryEscapeBO();
            bo.setEscapeCode(po.getCode());
            bo.setEscapeValue(po.getCodeTitle());
            bo.setParentCode(po.getParentCode());
            bo.setParentDesc(po.getParentDesc());
            bo.setRemark(po.getRemark());
            rspList.add(bo);
        }
        return rspList;
    }

    @Override
    public Map<String, String> mapEscapeByParentCode(String parentCode) {
        return EscapeCodeUtils.mapEscapeByParentCode(this.escapeCodeDao, parentCode);
    }

    @Override
    public void refresh(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return;
        }
        EscapeCodeUtils.refresh(this.escapeCodeDao, parentCode);
    }

    public void init() {
        new EscapeCodeUtils(this.cacheClient);
        EscapeCodeUtils.init(this.escapeCodeDao);
    }

    public void setEscapeCodeDao(EscapeCodeDao escapeCodeDao) {
        this.escapeCodeDao = escapeCodeDao;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (null == contextRefreshedEvent.getApplicationContext().getParent()) {
            this.init();
        }
    }
}

