/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class TkSpringBeanUtils
implements ApplicationContextAware {
    protected static final Log logger = LogFactory.getLog(TkSpringBeanUtils.class);
    private static ApplicationContext ctx = null;
    private static Map<String, Properties> propMap = new HashMap<String, Properties>(0);

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        TkSpringBeanUtils.ctx = ctx;
    }

    public static ApplicationContext getApplicationContext() {
        return ctx;
    }

    public static <T> T getBean(String prop) {
        Object obj = ctx.getBean(prop);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("property=[" + prop + "],object=[" + obj + "]"));
        }
        return (T)obj;
    }

    public static Properties getProperties(String filepath) {
        if (propMap.containsKey(filepath)) {
            return propMap.get(filepath);
        }
        Resource resource = ctx.getResource(filepath);
        Properties prop = new Properties();
        try {
            prop.load(resource.getInputStream());
            propMap.put(filepath, prop);
            return prop;
        }
        catch (IOException e) {
            logger.error((Object)("can not find the resource file:[" + filepath + "]"), (Throwable)e);
            return null;
        }
    }
}

