/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util.snow;

import com.ohaotian.plugin.cache.CacheClient;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
public class TkSnowFlakeUtils
implements ApplicationRunner,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(TkSnowFlakeUtils.class);
    @Autowired
    private CacheClient tkRedis;
    private static final long START = 1420041600000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static Long dataWorkId = 0L;
    private static Long dataCenterId;
    private static long sequence;
    private static long lastTimestamp;

    @Value(value="${snow.flake.center.id:0}")
    public void setDataCenterId(Long dataCenterId) {
        TkSnowFlakeUtils.dataCenterId = dataCenterId;
    }

    public static synchronized long nextId() {
        long timestamp = TkSnowFlakeUtils.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("\u751f\u6210ID\u5e76\u53d1\u65f6\u95f4\u5c0f\u4e8e\u9600\u503c.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = TkSnowFlakeUtils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1420041600000L << 22 | dataCenterId << 17 | dataWorkId << 12 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = TkSnowFlakeUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = TkSnowFlakeUtils.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    public static long randomCenterId() {
        return new Random(new Random().nextLong()).nextInt(31);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (contextRefreshedEvent.getApplicationContext().getParent() == null) {
            this.initWorkId();
        }
    }

    public void run(ApplicationArguments args) {
        this.initWorkId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWorkId() {
        logger.debug("\u521d\u59cb\u5316\u96ea\u82b1\u5e8f\u5217workId\u5f00\u59cb");
        if (null != dataWorkId) {
            return;
        }
        String workIdKey = "TK_WORK_ID_" + TkSnowFlakeUtils.getLinuxLocalIp();
        String workIdCountKey = "TK_WORK_ID_COUNT_" + dataCenterId;
        logger.debug("\u5f53\u524dkey=" + workIdKey);
        try (Jedis jedis = null;){
            jedis = this.tkRedis.getJedisPool().getResource();
            Object workIdObj = null;
            if (null != workIdObj) {
                dataWorkId = Long.valueOf(workIdObj.toString());
                return;
            }
            long workId = jedis.incrBy(workIdCountKey, 1L);
            jedis.set(workIdKey, String.valueOf(workId));
            System.out.println("\u96ea\u82b1\u5e8f\u5217\u5f97\u5230\u7684\u673a\u5668\u7801=" + workId);
            dataWorkId = workId;
            if (workId >= 31L) {
                jedis.del(workIdCountKey);
            }
        }
    }

    public static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                    System.out.println(ipaddress);
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    static {
        sequence = 0L;
        lastTimestamp = -1L;
    }
}

