/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.toolkit.dao.EscapeCodeDao;
import com.tydic.newretail.toolkit.dao.po.EscapeCodePO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeCodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(EscapeCodeUtils.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    private static CacheClient cacheClient;
    private static String ESCAPE_PREFIX;
    private static String PARENT_PREFIX;

    public EscapeCodeUtils(CacheClient client) {
        cacheClient = client;
    }

    public static void refresh(EscapeCodeDao escapeCodeDao, String parentCode) {
        if (isDebug.booleanValue()) {
            logger.debug("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58" + parentCode);
        }
        try {
            cacheClient.delete(PARENT_PREFIX + parentCode);
            Set keys = cacheClient.getkeys(ESCAPE_PREFIX + parentCode + "*");
            if (CollectionUtils.isNotEmpty((Collection)keys)) {
                for (String key : keys) {
                    cacheClient.delete(key);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u7f13\u5b58\u3010" + parentCode + "\u3011\u5931\u8d25");
        }
        List<EscapeCodePO> pos = null;
        try {
            pos = escapeCodeDao.selectByParentCode(parentCode);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7236\u7ea7\u7f16\u7801\u67e5\u8be2\u7801\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(pos)) {
            return;
        }
        EscapeCodeUtils.setToCache(pos);
        if (isDebug.booleanValue()) {
            logger.debug("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\u5b8c\u6bd5");
        }
    }

    public static void init(EscapeCodeDao escapeCodeDao) {
        logger.debug("\u542f\u52a8\u52a0\u8f7d\u7801\u8868");
        List<EscapeCodePO> escapeCodePOS = null;
        try {
            escapeCodePOS = escapeCodeDao.selectAll();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5b57\u5178\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(escapeCodePOS)) {
            return;
        }
        EscapeCodeUtils.setToCache(escapeCodePOS);
        logger.debug("\u7801\u8868\u52a0\u8f7d\u5b8c\u6bd5");
    }

    private static void setToCache(List<EscapeCodePO> escapeCodePOS) {
        for (EscapeCodePO po : escapeCodePOS) {
            String key = ESCAPE_PREFIX + po.getParentCode() + "_" + po.getCode();
            String value = po.getCodeTitle();
            try {
                cacheClient.set(key, (Object)value);
            }
            catch (Exception e) {
                logger.error("\u3010" + key + "\u3011\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    public static String getCodeTitle(EscapeCodeDao escapeCodeDao, String parentCode, String code) {
        String key = ESCAPE_PREFIX + parentCode + "_" + code;
        Object valueObj = null;
        try {
            valueObj = cacheClient.get(key);
        }
        catch (Exception e) {
            logger.error("\u4ece\u7f13\u5b58\u4e2d\u67e5\u8be2\u3010" + key + "\u3011\u5931\u8d25");
        }
        if (null != valueObj) {
            return valueObj.toString();
        }
        EscapeCodePO record = new EscapeCodePO();
        record.setParentCode(parentCode);
        record.setCode(code);
        try {
            valueObj = escapeCodeDao.selectByParentCodeAndCode(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u3010" + key + "\u3011\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null == valueObj) {
            return null;
        }
        try {
            cacheClient.set(key, (Object)valueObj.toString());
        }
        catch (Exception e) {
            logger.error("\u3010" + key + "\u3011\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return valueObj.toString();
    }

    public static List<EscapeCodePO> listEscapeByParentCode(EscapeCodeDao escapeCodeDao, String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            logger.error("\u7236\u7ea7\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        List<EscapeCodePO> escapeCodePOS = null;
        try {
            Object obj = cacheClient.get(PARENT_PREFIX + parentCode);
            if (null != obj) {
                return (List)obj;
            }
            escapeCodePOS = escapeCodeDao.selectByParentCode(parentCode);
            if (CollectionUtils.isEmpty(escapeCodePOS)) {
                return null;
            }
            cacheClient.set(PARENT_PREFIX + parentCode, escapeCodePOS);
            return escapeCodePOS;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8f6c\u4e49\u7801\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u8f6c\u4e49\u7801\u5931\u8d25");
        }
    }

    public static Map<String, String> mapEscapeByParentCode(EscapeCodeDao escapeCodeDao, String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            logger.error("\u7236\u7ea7\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        List<EscapeCodePO> escapeCodePOS = EscapeCodeUtils.listEscapeByParentCode(escapeCodeDao, parentCode);
        if (CollectionUtils.isEmpty(escapeCodePOS)) {
            return null;
        }
        try {
            for (EscapeCodePO escapeCodePO : escapeCodePOS) {
                result.put(escapeCodePO.getCode(), escapeCodePO.getCodeTitle());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8f6c\u4e49\u7801\u5931\u8d25\uff1a", (Throwable)e);
            throw new ResourceException("0003", e.getMessage());
        }
        return result;
    }

    static {
        ESCAPE_PREFIX = "EXTESCAPE_";
        PARENT_PREFIX = "EXTESCAPE_PARENT_";
    }
}

