/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.alibaba.dubbo.common.utils.IOUtils;
import com.alibaba.dubbo.common.utils.PojoUtils;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.bo.RequestRecordBO;
import com.tydic.newretail.toolkit.thread.WriteRestLogsThread;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkSpringBeanUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKGenericServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(TKGenericServiceUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object genericServiceInvoke(String reqParams, HttpServletRequest request, InvokeInfo invokeInfo) {
        Object result;
        block16: {
            result = null;
            GenericService genericService = invokeInfo.getGenericService();
            if (StringUtils.isNotBlank((CharSequence)invokeInfo.getBeanName())) {
                genericService = (GenericService)TkSpringBeanUtils.getBean(invokeInfo.getBeanName());
                invokeInfo.setGenericService(genericService);
            }
            if (null != invokeInfo.getMethod()) {
                invokeInfo.setMethodName(invokeInfo.getMethod().getName());
            }
            if (null == genericService || StringUtils.isBlank((CharSequence)invokeInfo.getMethodName())) {
                return TKGenericServiceUtils.getErrorRsp("8888", "\u6cdb\u5316\u8c03\u7528\u7c7b\u6216\u65b9\u6cd5\u4e3a\u7a7a");
            }
            Object paramMap = null;
            String params = null;
            params = StringUtils.isNotBlank((CharSequence)reqParams) ? reqParams : TKGenericServiceUtils.getInputParams(request);
            String[] paramTypeReq = null;
            Object[] paramValueReq = null;
            if (StringUtils.isNotBlank((CharSequence)invokeInfo.getParamType())) {
                paramTypeReq = new String[]{invokeInfo.getParamType()};
                if (StringUtils.isBlank((CharSequence)params)) {
                    return TKGenericServiceUtils.getErrorRsp("8888", "\u5165\u53c2\u4e3a\u7a7a");
                }
                paramMap = JSON.parseObject((String)params);
                paramValueReq = new Object[]{PojoUtils.generalize((Object)paramMap)};
            }
            RequestRecordBO record = new RequestRecordBO();
            if (null != paramMap) {
                record.setRequestInput(paramMap.toString());
            }
            long startTime = System.currentTimeMillis();
            long totalTime = 0L;
            record.setRequestTime(new Date());
            result = invokeInfo.getGenericService().$invoke(invokeInfo.getMethodName(), paramTypeReq, paramValueReq);
            totalTime = System.currentTimeMillis() - startTime;
            record.setReponseTime(new Date());
            try {
                TKGenericServiceUtils.writeLogs(totalTime, startTime, result, record, invokeInfo, request);
            }
            catch (Exception e) {
                logger.error("\u5199\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            }
            break block16;
            catch (Exception e) {
                JSONObject jSONObject;
                try {
                    logger.error("\u6cdb\u5316\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
                    record.setRequestOutput("\u6cdb\u5316\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
                    jSONObject = TKGenericServiceUtils.getErrorRsp("8888", "\u6cdb\u5316\u8c03\u7528\u5f02\u5e38");
                }
                catch (Throwable throwable) {
                    try {
                        TKGenericServiceUtils.writeLogs(totalTime, startTime, result, record, invokeInfo, request);
                    }
                    catch (Exception e2) {
                        logger.error("\u5199\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff1a" + e2.getMessage());
                    }
                    throw throwable;
                }
                try {
                    TKGenericServiceUtils.writeLogs(totalTime, startTime, result, record, invokeInfo, request);
                }
                catch (Exception e3) {
                    logger.error("\u5199\u65e5\u5fd7\u6587\u4ef6\u5f02\u5e38\uff1a" + e3.getMessage());
                }
                return jSONObject;
            }
        }
        return result;
    }

    public static JSONObject getErrorRsp(String respCode, String respDesc) {
        JSONObject result = new JSONObject();
        result.put((Object)"respCode", (Object)respCode);
        result.put((Object)"respDesc", (Object)respDesc);
        return result;
    }

    public static String getInputParams(HttpServletRequest request) {
        String params = null;
        BufferedReader reader = null;
        try {
            if (null != request.getInputStream()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                params = IOUtils.read((Reader)reader);
            }
            String string = params;
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("\u83b7\u53d6\u5165\u53c2\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    public static void writeLogs(long totalTime, long startTime, Object result, RequestRecordBO record, InvokeInfo invokeInfo, HttpServletRequest request) {
        if (0L == totalTime) {
            totalTime = System.currentTimeMillis() - startTime;
        }
        record.setRequestMethod(invokeInfo.getMethodName());
        record.setRequestType(request.getMethod());
        String url = request.getRequestURL().toString();
        if (StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
            url = url + "?" + request.getQueryString();
        }
        record.setRequestUrl(url);
        record.setTimeConsuming(Long.valueOf(totalTime));
        if (null != invokeInfo.getMethod()) {
            record.setRequestService(String.valueOf(invokeInfo.getMethod()));
        }
        if (null != invokeInfo.getGenericService()) {
            record.setRequestService(invokeInfo.getGenericService().toString());
        }
        if (null == record.getReponseTime()) {
            record.setReponseTime(new Date());
        }
        if (null != record.getRequestTime()) {
            record.setRequestTimeStr(TkDateUtils.formatDate(record.getRequestTime(), "yyyy-MM-dd HH:mm:ss SSS"));
        }
        if (null != record.getReponseTime()) {
            record.setResponseTimeStr(TkDateUtils.formatDate(record.getReponseTime(), "yyyy-MM-dd HH:mm:ss SSS"));
        }
        record.setRequestInput(record.getRequestInput());
        if (null != result) {
            try {
                record.setRequestOutput(JSON.toJSONString((Object)result));
            }
            catch (Exception e) {
                logger.error("\u51fa\u53c2\u8f6c\u6362\u5931\u8d25");
            }
        }
        WriteRestLogsThread thread = new WriteRestLogsThread();
        thread.addRequestRecordBO(record);
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(1);
        linkedBlockingQueue.add(thread);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("WRITERESTLOGS-%d").build();
        ThreadPoolExecutor singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, linkedBlockingQueue, namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        singleThreadPool.execute(thread);
        singleThreadPool.shutdown();
    }
}

