/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.util.SerializeUtils;
import com.tydic.newretail.toolkit.bo.MqProducerBO;
import com.tydic.newretail.toolkit.util.EscapeCodeUtils;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkProducerUtil {
    private static final Logger logger = LoggerFactory.getLogger(EscapeCodeUtils.class);

    public static SendResult send(MqProducerBO mqBO) {
        if (null == mqBO || null == mqBO.getBody()) {
            throw new ResourceException("9999", "\u6d88\u606f\u4f53\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)mqBO.getGid())) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
            throw new ResourceException("9999", "\u751f\u4ea7\u8005\u5165\u53c2GID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)mqBO.getTopic())) {
            logger.error("\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
            throw new ResourceException("9999", "\u751f\u4ea7\u8005\u5165\u53c2TOPIC\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)mqBO.getTag())) {
            mqBO.setTag("*");
        }
        logger.info("send start---");
        SendResult sendResult = new SendResult();
        Properties properties = new Properties();
        properties.setProperty("GROUP_ID", mqBO.getGid());
        String accessKey = TkPropertiesUtils.getProperty("mq.accessKey");
        String secretKey = TkPropertiesUtils.getProperty("mq.secretKey");
        String onsAddr = TkPropertiesUtils.getProperty("mq.onsAddr");
        String sendMsgTimeoutMillis = TkPropertiesUtils.getProperty("mq.sendMsgTimeoutMillis", "3000");
        if (StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)secretKey) || StringUtils.isBlank((CharSequence)onsAddr)) {
            logger.error("\u672a\u83b7\u53d6ONS\u76f8\u5173\u914d\u7f6e\uff1amq.accessKey|secretKey|onsAddr");
            return sendResult;
        }
        logger.info("mq\u751f\u4ea7\u8005\u914d\u7f6e\u83b7\u53d6\u6210\u529f\uff0cTOPIC=" + mqBO.getTopic() + "\uff0cGID=" + mqBO.getGid() + "\uff0cTAG=" + mqBO.getTag() + "\uff0cACCESS_KEY=" + accessKey + "\uff0cSECRET_KEY=" + secretKey + "\uff0cONS_ADDR=" + onsAddr);
        properties.put("AccessKey", accessKey);
        properties.put("SecretKey", secretKey);
        properties.setProperty("SendMsgTimeoutMillis", sendMsgTimeoutMillis);
        properties.put("ONSAddr", onsAddr);
        Producer producer = ONSFactory.createProducer((Properties)properties);
        producer.start();
        Message msg = new Message(mqBO.getTopic(), mqBO.getTag(), SerializeUtils.serialize((Object)mqBO.getBody()));
        try {
            sendResult = producer.send(msg);
            logger.info(sendResult.toString());
            if (sendResult != null) {
                logger.info(new Date() + " Send mq message success. Topic is:" + msg.getTopic() + " msgId is: " + sendResult.getMessageId());
            }
        }
        catch (Exception e) {
            logger.error(new Date() + " Send mq message failed. Topic is:" + msg.getTopic() + "\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            throw new ResourceException("9999", "\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
        producer.shutdown();
        return sendResult;
    }

    public static void main(String[] args) {
        MqProducerBO mq = new MqProducerBO();
        mq.setGid("GID_UATBUY_COMM");
        mq.setTopic("UATBUY_COMM");
        mq.setTag("*");
        mq.setBody((Object)"test");
        TkProducerUtil.send(mq);
    }
}

