/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.tydic.newretail.toolkit.execption.TkBusinessException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKFileUtils {
    private static final Logger log = LoggerFactory.getLogger(TKFileUtils.class);
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void writeBytesToFile(byte[] bs, String path) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        ByteArrayInputStream is = new ByteArrayInputStream(bs);
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = is.read(buff)) != -1) {
            ((OutputStream)out).write(buff, 0, len);
        }
        ((InputStream)is).close();
        ((OutputStream)out).close();
    }

    public static byte[] strToByteArray(String str) {
        if (str == null) {
            return null;
        }
        byte[] byteArray = str.getBytes();
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(String filePath) {
        FileInputStream stream = null;
        ByteArrayOutputStream out = null;
        File f = new File(filePath);
        if (!f.exists() || !f.isFile()) {
            return null;
        }
        try {
            int n;
            stream = new FileInputStream(f);
            out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static FilenameFilter filter(final String regex) {
        return new FilenameFilter(){
            private Pattern pattern;
            {
                this.pattern = Pattern.compile(regex);
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.pattern.matcher(name).matches();
            }
        };
    }

    public static File[] getFilesByPattern(String pattern, File file) {
        File[] list = StringUtils.isBlank((CharSequence)pattern) ? file.listFiles() : file.listFiles(TKFileUtils.filter(pattern));
        return list;
    }

    public static void write(String filePath, String fileContent) {
        try {
            FileOutputStream fo = new FileOutputStream(filePath);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fo, "UTF-8");
            out.write(fileContent);
            out.close();
        }
        catch (IOException ex) {
            log.error("\u628a\u5185\u5bb9\u5199\u5165\u6587\u4ef6" + filePath + "\u5931\u8d25:" + ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static void appendFile(String file, String conent) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
            out.write(conent + "\r\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Date getCreateTime(String fullFileName) {
        Path path = Paths.get(fullFileName, new String[0]);
        BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            BasicFileAttributes attr = basicview.readAttributes();
            Date createDate = new Date(attr.creationTime().toMillis());
            return createDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            Calendar cal = Calendar.getInstance();
            cal.set(1970, 0, 1, 0, 0, 0);
            return cal.getTime();
        }
    }

    public static File createTempFile(String suffix) {
        File file;
        try {
            String path = System.getProperty("java.io.tmpdir");
            String tempFileName = path + File.separator + UUID.randomUUID() + suffix;
            log.debug("tempFileName:" + tempFileName);
            file = new File(tempFileName);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Object)e.getMessage());
            throw new TkBusinessException("9999", "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
        }
        return file;
    }

    public static void main(String[] args) throws Exception {
    }
}

