/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKSftpUtils {
    private static final Logger loggerMonitor = LoggerFactory.getLogger(TKSftpUtils.class);
    private static ChannelSftp ftpClient = null;
    private static Session sshSession = null;

    public static ChannelSftp getConnect(String host, String port, String userName, String password) throws Exception {
        try {
            JSch jsch = new JSch();
            sshSession = jsch.getSession(userName, host, Integer.parseInt(port));
            sshSession.setPassword(password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect(30000);
            ftpClient = (ChannelSftp)sshSession.openChannel("sftp");
            ftpClient.connect();
            loggerMonitor.debug("success ..........");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8fde\u63a5sftp\u670d\u52a1\u5668\u5f02\u5e38\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        }
        return ftpClient;
    }

    public static void download(String ftp_path, String save_path, String oldFileName, String newFileName) throws Exception {
        FileOutputStream fos = null;
        try {
            ftpClient.cd(ftp_path);
            File file = new File(save_path);
            if (!file.exists()) {
                file.mkdirs();
            }
            String saveFile = save_path + "/" + newFileName;
            File file1 = new File(saveFile);
            fos = new FileOutputStream(file1);
            ftpClient.get(oldFileName, (OutputStream)fos);
        }
        catch (Exception e) {
            loggerMonitor.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38............", (Object)e.getMessage());
            throw new Exception("download file error............");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("close stream error..........");
                }
            }
        }
    }

    public static void uploadFile(String upload_path, String ftp_path, String newFileName) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(upload_path));
            ftpClient.cd(ftp_path);
            ftpClient.put((InputStream)fis, newFileName, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Upload file error.");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new Exception("close stream error.");
                }
            }
        }
    }

    public static void close() throws Exception {
        loggerMonitor.debug("close............");
        try {
            ftpClient.disconnect();
            sshSession.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("close stream error.");
        }
    }

    public static void main(String[] args) {
        try {
            TKSftpUtils.getConnect("ip\u5730\u5740", "22", "\u7528\u6237\u540d", "\u5bc6\u7801");
            TKSftpUtils.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

