/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.tydic.newretail.toolkit.util.TkOssConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsFileUtils {
    private static final Logger log = LoggerFactory.getLogger(ObsFileUtils.class);

    public static void uploadFilePubMethodObs(File file, String uploadPath, TkOssConfig ossConfig) {
        ObsClient obsClient = ObsFileUtils.getObsClient(ossConfig);
        String fileName = file.getName();
        try {
            FileInputStream inputStream = new FileInputStream(file);
            long available = ((InputStream)inputStream).available();
            PutObjectRequest request = new PutObjectRequest(ossConfig.getBucketName(), uploadPath + fileName, (InputStream)inputStream);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength(Long.valueOf(available));
            request.setMetadata(objectMetadata);
            request.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
            PutObjectResult putObjectResult = obsClient.putObject(request);
        }
        catch (ObsException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0bobs\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (null != obsClient) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("obs\u6267\u884c\u5f02\u5e38\uff01", (Throwable)e);
                }
            }
        }
    }

    public static File downloadFileFromPath(String filePath, TkOssConfig ossConfig, boolean reName) {
        ObsClient obsClient = ObsFileUtils.getObsClient(ossConfig);
        String dir = System.getProperty("java.io.tmpdir");
        File dirFile = null;
        dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        String fileName = filePath.substring(filePath.lastIndexOf("/"), filePath.length());
        if (reName) {
            fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        }
        dir = dir + File.separator + fileName;
        dirFile = new File(dir);
        try {
            ObsObject obsObject = obsClient.getObject(ossConfig.getBucketName(), filePath);
            InputStream input = obsObject.getObjectContent();
            FileUtils.copyInputStreamToFile((InputStream)input, (File)dirFile);
        }
        catch (Throwable e) {
            log.error("\u4eceobs\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (null != obsClient) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("obs\u6267\u884c\u5f02\u5e38\uff01", (Throwable)e);
                }
            }
        }
        return dirFile;
    }

    public String getFileUrl(String filePath, TkOssConfig ossConfig) {
        TemporarySignatureRequest request = new TemporarySignatureRequest();
        request.setBucketName(ossConfig.getBucketName());
        request.setObjectKey(filePath);
        request.setRequestDate(new Date());
        request.setExpires(60L);
        ObsClient obsClient = new ObsClient(ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), ossConfig.getEndpoint());
        TemporarySignatureResponse signature = obsClient.createTemporarySignature(request);
        log.info("download signedUrl-> {}", (Object)signature.getSignedUrl());
        return signature.getSignedUrl();
    }

    public static ObsClient getObsClient(TkOssConfig ossConfig) {
        return new ObsClient(ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), ossConfig.getEndpoint());
    }
}

