/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class TkDateUtils {
    public static final String MMDD = "MM-dd";
    public static final String MMDDHHMM = "MM-dd HH:mm";
    public static final String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDD = "yyyy-MM-dd";
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String yyyyMMddHH = "yyyyMMddHH";
    public static final String yyyyMMddHHmm = "yyyyMMddHHmm";

    public static boolean belongCalendar(Date nowTime, Date beginTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.after(begin) && date.before(end)) {
            return true;
        }
        return nowTime.compareTo(beginTime) == 0 || nowTime.compareTo(endTime) == 0;
    }

    public static Date getZeroTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zero = calendar.getTime();
        return zero;
    }

    public static Date getLastTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date zero = calendar.getTime();
        return zero;
    }

    public static Date formatDateStrToDate(String strDate, String formatStr) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(formatStr);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static String formatDate(Date date, String formatStr) {
        SimpleDateFormat formatDate = new SimpleDateFormat(formatStr);
        String resultTime = formatDate.format(date);
        return resultTime;
    }

    public static String dateToDatetimeStr(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(YYYYMMDDHHMMSS);
        String dataStr = format.format((Object)date);
        return dataStr;
    }

    public static String dateToDateStr(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(YYYYMMDD);
        String dataStr = format.format((Object)date);
        return dataStr;
    }

    public static Date datetimeStrToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMMDDHHMMSS);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static Date dateStrToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMMDD);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static Date getDate(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (days != null) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static int diffDay(Date start, Date end) {
        int days = (int)((end.getTime() - start.getTime()) / 86400000L);
        return days;
    }

    public static int diffHour(Date start, Date end) {
        int days = (int)((end.getTime() - start.getTime()) / 3600000L);
        return days;
    }

    public static int diffMinute(Date start, Date end) {
        int days = (int)((end.getTime() - start.getTime()) / 60000L);
        return days;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static Date initDateByCondition(Date date, String condition) {
        Calendar calendar = Calendar.getInstance();
        int dateNum = 0;
        int dateType = 0;
        switch (condition) {
            case "WEEK": {
                dateNum = -7;
                dateType = 5;
                break;
            }
            case "HALFOFYEAR": {
                dateNum = -6;
                dateType = 2;
                break;
            }
            case "YEAR": {
                dateNum = -1;
                dateType = 1;
                break;
            }
            case "HALFOFMONTH": {
                dateNum = -15;
                dateType = 5;
                break;
            }
            default: {
                dateNum = -1;
                dateType = 2;
            }
        }
        calendar.setTime(date);
        calendar.add(dateType, dateNum);
        return calendar.getTime();
    }

    public static void main(String[] args) {
        Date callTime = TkDateUtils.formatDateStrToDate("202303161501111", yyyyMMddHHmmssSSS);
        int minutes = TkDateUtils.diffMinute(callTime, new Date());
        System.out.println(minutes);
    }
}

