/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.util.ConverterUtils;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.toolkit.constant.ExportConstant;
import com.tydic.newretail.toolkit.util.MergeCellSheetWriteHandler;
import com.tydic.newretail.toolkit.util.TKFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.SAXHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TkExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(TkExcelUtils.class);

    public static List<XSSFRow> readXlsx(String path, int startSheet, int startRow) {
        FileInputStream is = null;
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            is = new FileInputStream(path);
            xssfWorkbook = new XSSFWorkbook((InputStream)is);
            for (int numSheet = startSheet; numSheet < xssfWorkbook.getNumberOfSheets(); ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<XSSFRow> readXlsx(String path, int startSheet, int endSheet, int startRow) {
        FileInputStream is = null;
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            is = new FileInputStream(path);
            xssfWorkbook = new XSSFWorkbook((InputStream)is);
            if (endSheet == 0) {
                endSheet = xssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < endSheet; ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<HSSFRow> readXls(String path, int startSheet, int startRow) {
        FileInputStream is = null;
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            is = new FileInputStream(path);
            hssfWorkbook = new HSSFWorkbook((InputStream)is);
            for (int numSheet = startSheet; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return hssfRows;
    }

    public static List<HSSFRow> readXls(String path, int startSheet, int endSheet, int startRow) {
        FileInputStream is = null;
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            is = new FileInputStream(path);
            hssfWorkbook = new HSSFWorkbook((InputStream)is);
            if (endSheet == 0) {
                endSheet = hssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < endSheet; ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new ResourceException("0015", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("9999", e.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return hssfRows;
    }

    public static String changeCellToString(Cell cell, Boolean isDecimal) {
        String returnValue = "";
        if (null != cell) {
            switch (cell.getCellType()) {
                case 0: {
                    String whatYourWant;
                    if (isDecimal.booleanValue()) {
                        String whatYourWant2;
                        DecimalFormat df = new DecimalFormat("0.00");
                        returnValue = whatYourWant2 = df.format(cell.getNumericCellValue());
                        break;
                    }
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        returnValue = formater.format(date);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat("0");
                    returnValue = whatYourWant = df.format(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    returnValue = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    Boolean booleanValue = cell.getBooleanCellValue();
                    returnValue = booleanValue.toString();
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    returnValue = cell.getCellFormula();
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    logger.error("\u672a\u77e5\u7c7b\u578b");
                }
            }
        }
        return returnValue;
    }

    public static String getSuffix(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(".") + 1, path.length());
        }
        return null;
    }

    public static File mergeXlsx(List<File> files) {
        File finalFile = TKFileUtils.createTempFile(".xlsx");
        int i = 0;
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        List<Object> heads = new ArrayList();
        for (File file : files) {
            List list = ((ExcelReaderBuilder)EasyExcel.read((File)file).headRowNumber(Integer.valueOf(i))).sheet(Integer.valueOf(0)).doReadSync();
            if (i == 0) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)list.get(0);
                heads = TkExcelUtils.getHeads(linkedHashMap);
                list.remove(linkedHashMap);
            }
            i = 1;
            datas.addAll(TkExcelUtils.getDatas(list));
        }
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((File)finalFile).registerWriteHandler((WriteHandler)new SimpleColumnWidthStyleStrategy(ExportConstant.EXPORT_DEFAULT_CELL_WIDTH))).sheet().head(heads)).doWrite(datas);
        return finalFile;
    }

    public static File mergeXlsx(List<File> files, List<Integer> margeOrderList, List<Integer> margeList) {
        File finalFile = TKFileUtils.createTempFile(".xlsx");
        int i = 0;
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        List<Object> heads = new ArrayList();
        for (File file : files) {
            List list = ((ExcelReaderBuilder)EasyExcel.read((File)file).headRowNumber(Integer.valueOf(i))).sheet(Integer.valueOf(0)).doReadSync();
            if (i == 0) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)list.get(0);
                heads = TkExcelUtils.getHeads(linkedHashMap);
                list.remove(linkedHashMap);
            }
            i = 1;
            datas.addAll(TkExcelUtils.getDatas(list));
        }
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)finalFile).registerWriteHandler((WriteHandler)new SimpleColumnWidthStyleStrategy(ExportConstant.EXPORT_DEFAULT_CELL_WIDTH))).registerWriteHandler((WriteHandler)new MergeCellSheetWriteHandler(margeList, margeOrderList))).sheet().head(heads)).doWrite(datas);
        return finalFile;
    }

    public static File mergeXlsxPOI(List<File> files, final List<Integer> margeOrderList, final List<Integer> margeList) {
        File finalFile = TKFileUtils.createTempFile(".xlsx");
        try (SXSSFWorkbook workbookAll = new SXSSFWorkbook();){
            final SXSSFSheet outputSheetAll = workbookAll.createSheet("\u9500\u552e\u65e5\u62a5");
            ExecutorService service = Executors.newFixedThreadPool(1);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    logger.debug("\u7ebf\u7a0b\u5408\u5e76\u5355\u5143\u683c");
                    Integer mergeProvStart = 1;
                    Integer mergeProvEnd = 0;
                    int mergeCellsCount = 0;
                    for (Integer merge : margeOrderList) {
                        if (merge == 0) continue;
                        mergeProvEnd = mergeProvEnd + merge;
                        if (merge != 1) {
                            for (Integer i : margeList) {
                                TkExcelUtils.addMergeRegion(new CellRangeAddress(mergeProvStart.intValue(), mergeProvEnd.intValue(), i.intValue(), i.intValue()), outputSheetAll, mergeCellsCount);
                                ++mergeCellsCount;
                            }
                        }
                        mergeProvStart = 1 + mergeProvEnd;
                    }
                    logger.debug("\u7ebf\u7a0b\u5408\u5e76\u5355\u5143\u683c\u5b8c\u4e8b\u4e86");
                }
            });
            OPCPackage opcPackage = null;
            InputStream inputStream = null;
            Boolean firstFile = true;
            SimpleSheetContentsHandler sheetContentsHandler = new SimpleSheetContentsHandler(outputSheetAll);
            for (File file : files) {
                sheetContentsHandler.setFirstFile(firstFile);
                try {
                    opcPackage = OPCPackage.open((File)file);
                    XSSFReader xssfReader = new XSSFReader(opcPackage);
                    StylesTable styles = xssfReader.getStylesTable();
                    ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(opcPackage);
                    inputStream = (InputStream)xssfReader.getSheetsData().next();
                    XMLReader sheetParser = SAXHelper.newXMLReader();
                    sheetParser.setContentHandler((ContentHandler)new XSSFSheetXMLHandler(styles, strings, (XSSFSheetXMLHandler.SheetContentsHandler)sheetContentsHandler, false));
                    try {
                        sheetParser.parse(new InputSource(inputStream));
                    }
                    catch (RuntimeException e) {
                        logger.error("\u5f02\u5e38", (Throwable)e);
                    }
                }
                catch (OpenXML4JException e) {
                    throw new RuntimeException(e);
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    opcPackage.close();
                    inputStream.close();
                }
                firstFile = false;
            }
            try (FileOutputStream fos = new FileOutputStream(finalFile);){
                workbookAll.write((OutputStream)fos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return finalFile;
    }

    public static File mergeXlsxAli(List<File> files) {
        File finalFile = TKFileUtils.createTempFile(".xlsx");
        try (SXSSFWorkbook workbookAll = new SXSSFWorkbook();){
            final SXSSFSheet outputSheetAll = workbookAll.createSheet("Sheet0");
            final AtomicInteger allRowNum = new AtomicInteger();
            Boolean firstFile = true;
            for (File file : files) {
                final Boolean finalFirstFile1 = firstFile;
                ReadListener<Map<Integer, String>> readListener = new ReadListener<Map<Integer, String>>(){

                    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
                        Map mapHead = ConverterUtils.convertToStringMap(headMap, (AnalysisContext)context);
                        if (finalFirstFile1.booleanValue()) {
                            SXSSFRow sXSSFRow = outputSheetAll.createRow(allRowNum.getAndIncrement());
                            AtomicInteger allCellNum = new AtomicInteger();
                            mapHead.forEach((key, value) -> {
                                SXSSFCell sXSSFCell = sXSSFRow.createCell(allCellNum.getAndIncrement());
                                sXSSFCell.setCellValue(value);
                            });
                        }
                    }

                    public void invoke(Map<Integer, String> data, AnalysisContext context) {
                        SXSSFRow sXSSFRow = outputSheetAll.createRow(allRowNum.getAndIncrement());
                        AtomicInteger allCellNum = new AtomicInteger();
                        data.forEach((key, value) -> {
                            SXSSFCell sXSSFCell = sXSSFRow.createCell(allCellNum.getAndIncrement());
                            sXSSFCell.setCellValue(value);
                        });
                    }

                    public void doAfterAllAnalysed(AnalysisContext context) {
                    }
                };
                EasyExcel.read((File)file, (ReadListener)readListener).sheet().doRead();
                firstFile = false;
            }
            logger.debug("\u6587\u4ef6\u5168\u90e8\u5408\u5e76\u5b8c\u6bd5\uff0c\u8868\u5934+\u6570\u636e\u884c\u6570=" + allRowNum);
            try (FileOutputStream fos = new FileOutputStream(finalFile);){
                workbookAll.write((OutputStream)fos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return finalFile;
    }

    public static File mergeXlsxAli(List<File> files, final List<Integer> margeOrderList, final List<Integer> margeList) {
        File finalFile = TKFileUtils.createTempFile(".xlsx");
        try (SXSSFWorkbook workbookAll = new SXSSFWorkbook();){
            final SXSSFSheet outputSheetAll = workbookAll.createSheet("Sheet0");
            ExecutorService service = Executors.newFixedThreadPool(1);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    logger.debug("\u7ebf\u7a0b\u5408\u5e76\u5355\u5143\u683c");
                    Integer mergeProvStart = 1;
                    Integer mergeProvEnd = 0;
                    int mergeCellsCount = 0;
                    for (Integer merge : margeOrderList) {
                        if (merge == 0) continue;
                        mergeProvEnd = mergeProvEnd + merge;
                        if (merge != 1) {
                            for (Integer i : margeList) {
                                TkExcelUtils.addMergeRegion(new CellRangeAddress(mergeProvStart.intValue(), mergeProvEnd.intValue(), i.intValue(), i.intValue()), outputSheetAll, mergeCellsCount);
                                ++mergeCellsCount;
                            }
                        }
                        mergeProvStart = 1 + mergeProvEnd;
                    }
                    logger.debug("\u7ebf\u7a0b\u5408\u5e76\u5355\u5143\u683c\u5b8c\u4e8b\u4e86");
                }
            });
            final AtomicInteger allRowNum = new AtomicInteger();
            Boolean firstFile = true;
            for (File file : files) {
                final Boolean finalFirstFile1 = firstFile;
                ReadListener<Map<Integer, String>> readListener = new ReadListener<Map<Integer, String>>(){

                    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
                        Map mapHead = ConverterUtils.convertToStringMap(headMap, (AnalysisContext)context);
                        if (finalFirstFile1.booleanValue()) {
                            SXSSFRow sXSSFRow = outputSheetAll.createRow(allRowNum.getAndIncrement());
                            AtomicInteger allCellNum = new AtomicInteger();
                            mapHead.forEach((key, value) -> {
                                SXSSFCell sXSSFCell = sXSSFRow.createCell(allCellNum.getAndIncrement());
                                sXSSFCell.setCellValue(value);
                            });
                        }
                    }

                    public void invoke(Map<Integer, String> data, AnalysisContext context) {
                        SXSSFRow sXSSFRow = outputSheetAll.createRow(allRowNum.getAndIncrement());
                        AtomicInteger allCellNum = new AtomicInteger();
                        data.forEach((key, value) -> {
                            SXSSFCell sXSSFCell = sXSSFRow.createCell(allCellNum.getAndIncrement());
                            sXSSFCell.setCellValue(value);
                        });
                    }

                    public void doAfterAllAnalysed(AnalysisContext context) {
                    }
                };
                EasyExcel.read((File)file, (ReadListener)readListener).sheet().doRead();
                firstFile = false;
            }
            logger.debug("\u6587\u4ef6\u5168\u90e8\u5408\u5e76\u5b8c\u6bd5\uff0c\u8868\u5934+\u6570\u636e\u884c\u6570=" + allRowNum);
            try (FileOutputStream fos = new FileOutputStream(finalFile);){
                workbookAll.write((OutputStream)fos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return finalFile;
    }

    public static File mergeXlsxPy(List<File> files, List<Integer> margeOrderList, List<Integer> margeList) {
        File finalFile = TKFileUtils.createTempFile(".xlsx");
        String pythonScriptPath = "/home/admin/mergeExcel.py";
        StringBuilder commandBuilder = new StringBuilder("python3 ");
        commandBuilder.append(pythonScriptPath);
        for (File file : files) {
            commandBuilder.append(" ").append(file.getAbsolutePath());
        }
        commandBuilder.append(" ").append(finalFile.getAbsolutePath());
        logger.debug("python\u811a\u672c\u53c2\u6570=" + commandBuilder.toString());
        try {
            String line;
            Process process = Runtime.getRuntime().exec(commandBuilder.toString());
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                logger.debug("Standard Output: " + line);
            }
            while ((line = errorReader.readLine()) != null) {
                logger.debug("Standard Error: " + line);
            }
            int exitCode = process.waitFor();
            logger.debug("\u5408\u5e76excelweis\u5b8c\u4e86" + exitCode);
            try (FileInputStream inputStream = new FileInputStream(finalFile);
                 SXSSFWorkbook workbook = new SXSSFWorkbook(new XSSFWorkbook((InputStream)inputStream), 1000);){
                SXSSFSheet outputSheet = workbook.getSheetAt(0);
                logger.debug("\u7ebf\u7a0b\u5408\u5e76\u5355\u5143\u683c");
                Integer mergeProvStart = 1;
                Integer mergeProvEnd = 0;
                int mergeCellsCount = 0;
                for (Integer merge : margeOrderList) {
                    if (merge == 0) continue;
                    mergeProvEnd = mergeProvEnd + merge;
                    if (merge != 1) {
                        for (Integer i : margeList) {
                            TkExcelUtils.addMergeRegion(new CellRangeAddress(mergeProvStart.intValue(), mergeProvEnd.intValue(), i.intValue(), i.intValue()), outputSheet, mergeCellsCount);
                            ++mergeCellsCount;
                        }
                    }
                    mergeProvStart = 1 + mergeProvEnd;
                }
                logger.debug("\u7ebf\u7a0b\u5408\u5e76\u5355\u5143\u683c\u5b8c\u4e8b\u4e86");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return finalFile;
    }

    private static void addMergeRegion(CellRangeAddress cra, SXSSFSheet sh, int mergeCellsCount) {
        CTWorksheet ctWorksheet = sh.getWorkbook().getXSSFWorkbook().getSheetAt(0).getCTWorksheet();
        CTMergeCells ctMergeCells = mergeCellsCount > 0 ? ctWorksheet.getMergeCells() : ctWorksheet.addNewMergeCells();
        CTMergeCell ctMergeCell = ctMergeCells.addNewMergeCell();
        ctMergeCell.setRef(cra.formatAsString());
    }

    private static List<List<Object>> getDatas(List<LinkedHashMap> list) {
        ArrayList<List<Object>> rspList = new ArrayList<List<Object>>();
        for (LinkedHashMap map : list) {
            ArrayList line = new ArrayList();
            for (Object key : map.keySet()) {
                line.add(map.get(key));
            }
            rspList.add(line);
        }
        return rspList;
    }

    private static Map<Integer, Integer> buildWidthMap(int size) {
        HashMap<Integer, Integer> widthMap = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            widthMap.put(i, ExportConstant.EXPORT_CELL_WIDTH);
        }
        return widthMap;
    }

    private static List<List<String>> getHeads(LinkedHashMap<Integer, String> hashMap) {
        ArrayList<List<String>> heads = new ArrayList<List<String>>();
        for (Integer key : hashMap.keySet()) {
            ArrayList<String> head = new ArrayList<String>();
            head.add(hashMap.get(key));
            heads.add(head);
        }
        return heads;
    }

    private static List<WriteHandler> getCustomWriteHaandlerList() {
        LinkedList list = Lists.newLinkedList();
        list.add(new SimpleColumnWidthStyleStrategy(Integer.valueOf(45)));
        return list;
    }

    public static void main(String[] args) {
        List<Integer> margeOrderList = Arrays.asList(1, 2, 2, 4, 3);
        List<Integer> margeList = Arrays.asList(1, 3, 4);
        File file1 = new File("/work/match/code/ydzd-springboot/ydzd-server/file1.xlsx");
        File file2 = new File("/work/match/code/ydzd-springboot/ydzd-server/file2.xlsx");
        ArrayList<File> list = new ArrayList<File>();
        list.add(file1);
        list.add(file2);
        File file = TkExcelUtils.mergeXlsx(list, margeOrderList, margeList);
        System.out.println(file.getPath());
    }

    public static class SimpleSheetContentsHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        protected SXSSFSheet outputSheetAll;
        protected Boolean firstFile;
        private SXSSFRow currentRow;
        private int currentRowNum;

        public SimpleSheetContentsHandler(SXSSFSheet outputSheetAll) {
            this.outputSheetAll = outputSheetAll;
        }

        public void setFirstFile(Boolean firstFile) {
            this.firstFile = firstFile;
        }

        public void startRow(int rowNum) {
            logger.debug("firstFile=" + this.firstFile);
            logger.debug("currentRowNum=" + this.currentRowNum);
            this.currentRow = this.firstFile != false || 0 != rowNum ? this.outputSheetAll.createRow(this.currentRowNum++) : this.outputSheetAll.getRow(this.currentRowNum);
        }

        public void endRow(int rowNum) {
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            int columnIndex = SimpleSheetContentsHandler.getColumnIndex(cellReference);
            SXSSFCell outputCell = this.currentRow.createCell(columnIndex);
            outputCell.setCellValue(formattedValue);
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }

        public static int getColumnIndex(String cellReference) {
            char[] columnChars;
            int columnIndex = 0;
            for (char c : columnChars = cellReference.replaceAll("[0-9]", "").toCharArray()) {
                columnIndex = columnIndex * 26 + (c - 65 + 1);
            }
            return columnIndex - 1;
        }
    }
}

