/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import com.tydic.newretail.toolkit.bo.TkFileBO;
import com.tydic.newretail.toolkit.util.ObsFileUtils;
import com.tydic.newretail.toolkit.util.TkOssConfig;
import com.tydic.newretail.toolkit.util.TkOssObjectRsp;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TkNewOssFileUtils {
    private static final Logger log = LoggerFactory.getLogger(TkNewOssFileUtils.class);
    @Value(value="${TK_OSS_ENDPOINT:}")
    private String endpoint;
    @Value(value="${TK_OSS_ACCESSKEY:}")
    private String accessKeyId;
    @Value(value="${TK_OSS_ACCESSKEY_SECRET:}")
    private String accessKeySecret;
    @Value(value="${TK_OSS_BUCKETNAME:}")
    private String bucketName;
    @Value(value="${TK_OSS_ACCESS_URL:}")
    private String accessUrl;
    @Value(value="${TK_MODE:}")
    private String mode;
    private static TkOssConfig ossConfig;
    private static final String MULTI_PART_KEY = "TK_MULTIPART_";

    @Bean
    public TkOssConfig tkNewOssConfig() {
        this.init();
        return ossConfig;
    }

    public void init() {
        if (StringUtils.isNotBlank((CharSequence)this.endpoint) && StringUtils.isNotBlank((CharSequence)this.accessKeyId) && StringUtils.isNotBlank((CharSequence)this.accessKeySecret) && StringUtils.isNotBlank((CharSequence)this.accessUrl)) {
            ossConfig = new TkOssConfig(this.endpoint, this.accessKeyId, this.accessKeySecret, this.bucketName, this.accessUrl, this.mode);
        }
    }

    public static TkOssConfig getOssConfig() {
        return ossConfig;
    }

    public static void uploadByUrl(String url, String filePath, TkOssConfig ossConfig) {
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        InputStream inputStream = null;
        try {
            inputStream = new URL(url).openStream();
            ossClient.putObject(ossConfig.getBucketName(), filePath, inputStream);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            log.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u7f51\u7edc\u6d41\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u4e0a\u4f20\u7f51\u7edc\u6d41\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyFile(String sourceBucketName, String targetBucketName, String sourceFileName, String targetFileName, TkOssConfig ossConfig) {
        if (StringUtils.isBlank((CharSequence)sourceFileName) || StringUtils.isBlank((CharSequence)targetFileName)) {
            log.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
            throw new RuntimeException("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)sourceBucketName)) {
            sourceBucketName = ossConfig.getBucketName();
        }
        if (StringUtils.isBlank((CharSequence)targetBucketName)) {
            targetBucketName = ossConfig.getBucketName();
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        try {
            ossClient.copyObject(sourceBucketName, sourceFileName, targetBucketName, targetFileName);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u62f7\u8d1doss\u6587\u4ef6\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u62f7\u8d1doss\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    public static TkOssObjectRsp listFilesByPage(String nextMarker, int maxKeys, String filePath, TkOssConfig ossConfig) {
        ObjectListing objectListing;
        if (0 > maxKeys || 1000 < maxKeys) {
            throw new RuntimeException("maxKeys\u4e0d\u80fd\u5c0f\u4e8e0\u4e14\u4e0d\u80fd\u5927\u4e8e1000");
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        TkOssObjectRsp rsp = new TkOssObjectRsp();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(ossConfig.getBucketName()).withMarker(nextMarker).withMaxKeys(Integer.valueOf(maxKeys));
        listObjectsRequest.setPrefix(filePath);
        try {
            objectListing = ossClient.listObjects(listObjectsRequest);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5217\u4e3eoss\u6587\u4ef6\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u5217\u4e3eoss\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        List sums = objectListing.getObjectSummaries();
        nextMarker = objectListing.getNextMarker();
        boolean isTruncated = objectListing.isTruncated();
        rsp.setTruncated(isTruncated);
        rsp.setOssObjectSummaries(sums);
        rsp.setNextMarker(nextMarker);
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OSSObjectSummary> listFiles(String filePath, Boolean readSubFile, TkOssConfig ossConfig) {
        List sums = new ArrayList();
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(ossConfig.getBucketName());
            if (!readSubFile.booleanValue()) {
                listObjectsRequest.setDelimiter("/");
            }
            if (!filePath.endsWith("/")) {
                filePath = filePath + "/";
            }
            listObjectsRequest.setPrefix(filePath);
            ObjectListing objectListing = ossClient.listObjects(listObjectsRequest);
            sums = objectListing.getObjectSummaries();
        }
        catch (OSSException var7) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
        }
        catch (ClientException var8) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
        }
        catch (Exception E) {
            log.error(E.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return sums;
    }

    public static void uploadFileToPath(File file, String uploadPath, TkOssConfig ossConfig) {
        if (uploadPath.startsWith("/")) {
            uploadPath = uploadPath.substring(1, uploadPath.length());
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        if ("obs".equals(ossConfig.getMode())) {
            ObsFileUtils.uploadFilePubMethodObs(file, uploadPath, ossConfig);
        } else {
            TkNewOssFileUtils.uploadFilePubMethod(file, uploadPath, ossConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer uploadContentToPath(String content, String uploadPath, TkOssConfig ossConfig) {
        if (uploadPath.startsWith("/")) {
            uploadPath = uploadPath.substring(1, uploadPath.length());
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(ossConfig.getBucketName(), uploadPath, (InputStream)new ByteArrayInputStream(content.getBytes()));
            putObjectRequest.setProcess("true");
            PutObjectResult result = ossClient.putObject(putObjectRequest);
            Integer n = result.getResponse().getStatusCode();
            return n;
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return 0;
    }

    public static File downloadFileFromPath(String filePath, TkOssConfig ossConfig, boolean reName) {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1, filePath.length());
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        if ("obs".equals(ossConfig.getMode())) {
            return ObsFileUtils.downloadFileFromPath(filePath, ossConfig, reName);
        }
        return TkNewOssFileUtils.downloadFilePubMethod(filePath, ossConfig, reName);
    }

    private static File downloadFilePubMethod(String filePath, TkOssConfig ossConfig, boolean reName) {
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        String dir = System.getProperty("java.io.tmpdir");
        File dirFile = null;
        dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        String fileName = filePath.substring(filePath.lastIndexOf("/"), filePath.length());
        if (reName) {
            fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        }
        dir = dir + File.separator + fileName;
        dirFile = new File(dir);
        try {
            ossClient.getObject(new GetObjectRequest(ossConfig.getBucketName(), filePath), dirFile);
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return dirFile;
    }

    private static void uploadFilePubMethod(File file, String uploadPath, TkOssConfig ossConfig) {
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        String fileName = file.getName();
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(ossConfig.getBucketName(), uploadPath + fileName, file);
            ossClient.putObject(putObjectRequest);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamingDownloadFromPath(String filePath, TkOssConfig ossConfig) {
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        String content = "";
        OSSObject ossObject = null;
        BufferedReader reader = null;
        try {
            String line;
            ossObject = ossClient.getObject(ossConfig.getBucketName(), filePath);
            reader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));
            while ((line = reader.readLine()) != null) {
                content = content + line;
            }
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (Throwable ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (null != ossObject) {
                try {
                    ossObject.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return content;
    }

    public static List<String> removeOssFile(List<String> keys, TkOssConfig ossConfig, Boolean quiet) {
        if (CollectionUtils.isEmpty(keys)) {
            throw new RuntimeException("\u6587\u4ef6\u96c6\u5408\u5fc5\u586b");
        }
        if (keys.size() > 1000) {
            throw new RuntimeException("\u6587\u4ef6\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e1000");
        }
        if (null == quiet) {
            quiet = true;
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = null;
        try {
            List deletedObjects;
            ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(ossConfig.getBucketName()).withKeys(keys).withQuiet(quiet.booleanValue()));
            List list = deletedObjects = deleteObjectsResult.getDeletedObjects();
            return list;
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5220\u9664oss\u6587\u4ef6\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u5220\u9664oss\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    public static File downLoadZipFile(List<TkFileBO> fileList, String zipName, TkOssConfig ossConfig) throws IOException {
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        if (StringUtils.isEmpty((CharSequence)zipName)) {
            zipName = UUID.randomUUID() + "zipFile";
        }
        File zipFile = File.createTempFile(zipName, ".zip");
        try {
            FileOutputStream f = new FileOutputStream(zipFile);
            CheckedOutputStream csum = new CheckedOutputStream(f, new Adler32());
            ZipOutputStream zos = new ZipOutputStream(csum);
            for (TkFileBO fileBO : fileList) {
                File dowFile = TkNewOssFileUtils.downloadFileFromPath(fileBO.getFilePath(), ossConfig, false);
                FileInputStream inputStream = new FileInputStream(dowFile);
                String prex = fileBO.getFilePath().substring(fileBO.getFilePath().lastIndexOf("."), fileBO.getFilePath().length());
                zos.putNextEntry(new ZipEntry(fileBO.getFileName() + prex));
                int bytesRead = 0;
                while ((bytesRead = ((InputStream)inputStream).read()) != -1) {
                    zos.write(bytesRead);
                }
                ((InputStream)inputStream).close();
                zos.closeEntry();
            }
            zos.close();
        }
        catch (Throwable e) {
            log.error("\u4ece" + ossConfig.getMode() == null ? "oss" : ossConfig.getMode() + "\u4e0a\u6279\u91cf\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519:", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return zipFile;
    }

    public static OSS getOssclient(TkOssConfig ossConfig) {
        return new OSSClientBuilder().build(ossConfig.getEndpoint(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret());
    }

    public static String getMulitipartUploadId(TkOssConfig ossConfig, String uploadPath) {
        if (uploadPath.startsWith("/")) {
            uploadPath = uploadPath.substring(1, uploadPath.length());
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(ossConfig.getBucketName(), uploadPath);
        InitiateMultipartUploadResult upresult = ossClient.initiateMultipartUpload(request);
        return upresult.getUploadId();
    }

    public static PartETag mulitipartUpload(TkOssConfig ossConfig, File file, String uploadPath, String uploadId, int partNum) {
        FileInputStream instream;
        if (uploadPath.startsWith("/")) {
            uploadPath = uploadPath.substring(1, uploadPath.length());
        }
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        try {
            instream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setBucketName(ossConfig.getBucketName());
        uploadPartRequest.setKey(uploadPath);
        uploadPartRequest.setUploadId(uploadId);
        uploadPartRequest.setInputStream((InputStream)instream);
        uploadPartRequest.setPartSize(file.length());
        uploadPartRequest.setPartNumber(partNum);
        UploadPartResult uploadPartResult = ossClient.uploadPart(uploadPartRequest);
        return uploadPartResult.getPartETag();
    }

    public static void completeMultipartUpload(TkOssConfig ossConfig, String uploadId, String uploadPath, List<PartETag> partETags) {
        if (null == ossConfig) {
            ossConfig = TkNewOssFileUtils.ossConfig;
        }
        OSS ossClient = TkNewOssFileUtils.getOssclient(ossConfig);
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(ossConfig.getBucketName(), uploadPath, uploadId, partETags);
        CompleteMultipartUploadResult completeMultipartUploadResult = ossClient.completeMultipartUpload(completeMultipartUploadRequest);
    }

    public static void main(String[] args) {
        TkOssConfig ossConfig = new TkOssConfig("oss-cn-beijing.aliyuncs.com", "LTAI38CH6izuczTV", "ZWtqh1cXrxqFhv2MD9gWltJgvCIqyL", "uat-sale-retail", "http://oss-cn-beijing.aliyuncs.com/uat-sale-retail");
        File file = new File("/Users/Ario/Desktop/1\u6708\u4efd\u4e0b\u73ed\u6253\u5361\u7edf\u8ba1\u7684\u526f\u672c.xlsx");
        File file2 = new File("/Users/Ario/Desktop/1\u6708\u4efd\u4e0b\u73ed\u6253\u5361\u7edf\u8ba1\u7684\u526f\u672c2.xlsx");
        String uploadId = TkNewOssFileUtils.getMulitipartUploadId(ossConfig, "resfile/tempFiles/202304011735001.xlsx");
        PartETag partETag1 = TkNewOssFileUtils.mulitipartUpload(ossConfig, file, "resfile/tempFiles/202304011735001.xlsx", uploadId, 1);
        PartETag partETag2 = TkNewOssFileUtils.mulitipartUpload(ossConfig, file2, "resfile/tempFiles/202304011735001.xlsx", uploadId, 2);
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        partETags.add(partETag1);
        partETags.add(partETag2);
        TkNewOssFileUtils.completeMultipartUpload(ossConfig, uploadId, "resfile/tempFiles/202304011735001.xlsx", partETags);
    }
}

