/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util.snow;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ShortSequenceUtils
implements ApplicationRunner,
ApplicationListener<ContextRefreshedEvent> {
    private static Long dataWorkId = null;
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;

    public static synchronized long nextId() {
        long timestamp = ShortSequenceUtils.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("\u751f\u6210ID\u5e76\u53d1\u65f6\u95f4\u5c0f\u4e8e\u9600\u503c.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFL) == 0L) {
                timestamp = ShortSequenceUtils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1480166465631L << 10 | ShortSequenceUtils.randomCenterId() << 8 | dataWorkId << 4 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = ShortSequenceUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = ShortSequenceUtils.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    public static long randomCenterId() {
        return 0L;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.initWorkId();
        }
    }

    private void initWorkId() {
        System.out.println("\u521d\u59cb\u5316\u96ea\u82b1\u5e8f\u5217workId\u5f00\u59cb");
        String ip = ShortSequenceUtils.getLinuxLocalIp();
        System.out.println("\u521d\u59cb\u5316\u96ea\u82b1\u5e8f\u5217\u5f97\u5230IP=" + ip);
        String machineId = ip.substring(ip.length() - 1, ip.length());
        System.out.println("machineId=" + machineId);
        dataWorkId = Long.valueOf(machineId);
    }

    public static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                    System.out.println(ipaddress);
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.initWorkId();
    }
}

