/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.db;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Dialect;
import com.ohaotian.plugin.db.MySql5PageHepler;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.SpringContextUtil;
import com.tydic.newretail.toolkit.util.TkMD5Utils;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationStatementHandlerInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(PaginationStatementHandlerInterceptor.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    Dialect dialect = null;
    private CacheClient cacheClient;
    private Integer time = 600;
    public static final String CACHE_PREFIX = "TKDB_";
    private static final int LIMIT = 99999;
    private static final int OFFSET = 1409765410;
    private static final int LIMIT_EXPORT = 10000;

    public Object intercept(Invocation invocation) throws Throwable {
        if (isDebug.booleanValue()) {
            logger.debug("\u65b0\u5206\u9875\u62e6\u622a\u5668");
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        ParameterHandler parameterHandler = statementHandler.getParameterHandler();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaStatementHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
        if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        Configuration configuration = (Configuration)metaStatementHandler.getValue("delegate.configuration");
        String originalSql = (String)metaStatementHandler.getValue("delegate.boundSql.sql");
        Page page = (Page)rowBounds;
        int offset = page.getOffset();
        int limit = page.getLimit();
        if (-1 < offset && -1 < limit) {
            Connection connection = (Connection)invocation.getArgs()[0];
            originalSql = MySql5PageHepler.getLineSql(originalSql);
            originalSql = PaginationStatementHandlerInterceptor.getReplaceSql(connection, originalSql);
            long startTime = System.currentTimeMillis();
            String sql = PaginationStatementHandlerInterceptor.printSqlLog(configuration, boundSql);
            if (isDebug.booleanValue()) {
                logger.debug("==>printSqlLog\u8017\u65f6=" + (System.currentTimeMillis() - startTime));
            }
            int total = this.getTotal(parameterHandler, connection, originalSql, offset, limit, sql);
            page.setTotalCount(total);
            if (offset == 1409765410 && limit == 99999) {
                offset = 0;
                limit = 0;
            }
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)this.dialect.getLimitString(originalSql, offset, limit));
        }
        metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
        metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        String dialectClass = "com.ohaotian.plugin.db.MySql5Dialect";
        try {
            this.dialect = (Dialect)Class.forName(dialectClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot create dialect instance by dialectClass:" + dialectClass, e);
        }
        try {
            this.cacheClient = (CacheClient)SpringContextUtil.getBean("cacheClient");
        }
        catch (Exception e) {
            throw new RuntimeException("cannot create cacheClient instance " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getTotal(ParameterHandler parameterHandler, Connection connection, String originalSql, int offset, int limit, String sql) {
        int count = 0;
        Statement prepareStatement = null;
        ResultSet rs = null;
        try {
            if (originalSql.contains("order by") && originalSql.contains("force index")) {
                originalSql = originalSql.replaceAll("\\s+force\\s+index\\s*\\([^\\)]+\\)", "");
                if (isDebug.booleanValue()) {
                    logger.debug("\u53bb\u9664force index\u540e\u7684sql\u8bed\u53e5\uff1a" + originalSql);
                }
            }
            if (isDebug.booleanValue()) {
                logger.debug("offset:" + offset + ",limit:" + limit);
            }
            boolean isSelectDb = true;
            String countSql = null;
            boolean isLimit = false;
            if (offset == 1409765410 && limit == 99999) {
                if (isDebug.booleanValue()) {
                    logger.debug("\u83b7\u53d6\u771f\u5b9ecount");
                }
                countSql = this.dialect.getCountString(originalSql);
            } else if (limit == 10000) {
                if (isDebug.booleanValue()) {
                    logger.debug("\u5206\u9875\u67e5\u8be2\u83b7\u53d6count");
                }
                if (offset != 0) {
                    int n = count;
                    return n;
                }
                countSql = this.dialect.getCountString(originalSql);
            } else {
                countSql = this.dialect.getLimitCountString(originalSql);
                if (null == countSql) {
                    countSql = this.dialect.getCountString(originalSql);
                    isSelectDb = false;
                } else {
                    isLimit = true;
                }
            }
            if (isDebug.booleanValue()) {
                logger.debug("isSelectDb:" + isSelectDb + ",isLimit:" + isLimit + ",countSql\uff1a" + countSql);
            }
            prepareStatement = connection.prepareStatement(countSql);
            parameterHandler.setParameters((PreparedStatement)prepareStatement);
            long startTime = System.currentTimeMillis();
            String cacheKey = sql;
            cacheKey = TkMD5Utils.encrypByMd5((String)cacheKey);
            Object totalObj = this.cacheClient.get(CACHE_PREFIX + cacheKey);
            if (null != totalObj) {
                count = (Integer)totalObj;
                if (isDebug.booleanValue()) {
                    logger.debug("\u4eceredis\u83b7\u53d6count:" + count);
                }
                int n = count;
                return n;
            }
            String cacheLimitKey = null;
            if (isLimit) {
                cacheLimitKey = "select count(1) count from (" + sql + " limit 0,1001 ) t";
                cacheLimitKey = TkMD5Utils.encrypByMd5((String)cacheLimitKey);
                Object totalLimitObj = this.cacheClient.get(CACHE_PREFIX + cacheLimitKey);
                if (null != totalLimitObj) {
                    count = (Integer)totalLimitObj;
                    if (isDebug.booleanValue()) {
                        logger.debug("\u4eceredis\u83b7\u53d6limit,count:" + count);
                    }
                    int n = count;
                    return n;
                }
            }
            if (!isSelectDb) {
                int n = count;
                return n;
            }
            rs = prepareStatement.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            logger.info("\u4ece\u6570\u636e\u5e93\u83b7\u53d6count\uff0c\u5b58\u5165redis:" + count);
            if (count > 0) {
                if (isLimit) {
                    if (count > 1001) {
                        count = 1001;
                    }
                    this.cacheClient.set(CACHE_PREFIX + cacheLimitKey, (Object)count, this.time.intValue());
                } else {
                    this.cacheClient.set(CACHE_PREFIX + cacheKey, (Object)count, this.time.intValue());
                }
            }
            rs.close();
            prepareStatement.close();
            return count;
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u603b\u6761\u6570\u5931\u8d25\uff1a", (Object)e.getMessage());
            return count;
        }
        finally {
            try {
                if (null != rs && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            try {
                if (null != prepareStatement && !prepareStatement.isClosed()) {
                    prepareStatement.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
    }

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            if (isDebug.booleanValue()) {
                logger.debug("target.getClass():" + target.getClass());
            }
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return PaginationStatementHandlerInterceptor.realTarget(metaObject.getValue("h"));
        }
        return (T)target;
    }

    public static String printSqlLog(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = null;
        try {
            sql = boundSql.getSql().replaceAll("[\\s]+", " ");
            if (parameterMappings.size() > 0 && parameterObject != null) {
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    sql = sql.replaceFirst("\\?", parameterObject.toString());
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    for (ParameterMapping parameterMapping : parameterMappings) {
                        String parameterValue;
                        Object obj;
                        String propertyName = parameterMapping.getProperty();
                        if (metaObject.hasGetter(propertyName)) {
                            obj = metaObject.getValue(propertyName);
                            parameterValue = obj.toString();
                            sql = sql.replaceFirst("\\?", parameterValue);
                            continue;
                        }
                        if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                        obj = boundSql.getAdditionalParameter(propertyName);
                        parameterValue = obj.toString();
                        sql = sql.replaceFirst("\\?", parameterValue);
                    }
                }
            }
            if (isDebug.booleanValue()) {
                logger.debug("==> SQL:" + sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u83b7\u53d6\u771f\u5b9esql\u5931\u8d25\uff1a", (Object)e.getMessage());
            return null;
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReplaceSql(Connection connection, String originalSql) {
        PreparedStatement prepareStatement = null;
        ResultSet rs = null;
        try {
            String selectSql = "select repace_sql from sys_sql_replace where is_valid = '1' and query_key = ?";
            prepareStatement = connection.prepareStatement(selectSql);
            String sql = TkMD5Utils.encrypByMd5((String)originalSql);
            prepareStatement.setString(1, sql);
            if (isDebug.booleanValue()) {
                logger.debug("\u539f\u59cbsql\uff1a" + originalSql);
                logger.debug("\u52a0\u5bc6\u540esql\uff1a" + sql);
            }
            if ((rs = prepareStatement.executeQuery()).next()) {
                String repaceSql = rs.getString(1);
                if (StringUtils.isNotBlank((CharSequence)repaceSql)) {
                    originalSql = repaceSql;
                }
                if (isDebug.booleanValue()) {
                    logger.debug("\u66ff\u6362\u540e\u7684sql=" + repaceSql);
                }
            }
            rs.close();
            prepareStatement.close();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            logger.error("\u67e5\u8be2\u66ff\u6362sql\u5931\u8d25\uff1a", (Object)throwables.getMessage());
        }
        finally {
            try {
                if (null != rs && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            try {
                if (null != prepareStatement && !prepareStatement.isClosed()) {
                    prepareStatement.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
        return originalSql;
    }
}

