/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.share.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.session.ExpiringSession;

public class CacheSession
implements ExpiringSession,
Serializable {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 3024506719282139459L;
    private String id;
    private Map<String, Object> attributes;
    private long creationTime;
    private long lastAccessedTime;
    private boolean isNew;

    public CacheSession() {
        this("ZT-" + UUID.randomUUID());
    }

    public CacheSession(String id) {
        this.id = id;
        this.attributes = new HashMap<String, Object>();
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.isNew = true;
    }

    public CacheSession(ExpiringSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        this.id = session.getId();
        this.attributes = new HashMap<String, Object>(session.getAttributeNames().size());
        session.getAttributeNames().forEach(attrName -> {
            Object attrValue = session.getAttribute(attrName);
            this.attributes.put((String)attrName, attrValue);
        });
        this.lastAccessedTime = session.getLastAccessedTime();
        this.creationTime = session.getCreationTime();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setMaxInactiveIntervalInSeconds(int i) {
    }

    public int getMaxInactiveIntervalInSeconds() {
        return 0;
    }

    public boolean isExpired() {
        return false;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public <T> T getAttribute(String attributeName) {
        return (T)this.attributes.get(attributeName);
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            this.removeAttribute(attributeName);
        } else {
            this.attributes.put(attributeName, attributeValue);
        }
        this.isNew = true;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }
}

