/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.share.util;

import com.tydic.newretail.toolkit.share.util.WafKit;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class WafRequestWrapper
extends HttpServletRequestWrapper {
    private boolean filterXSS = true;
    private boolean filterSQL = true;

    public WafRequestWrapper(HttpServletRequest request, boolean filterXSS, boolean filterSQL) {
        super(request);
        this.filterXSS = filterXSS;
        this.filterSQL = filterSQL;
    }

    public WafRequestWrapper(HttpServletRequest request) {
        this(request, true, true);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.filterParamString(values[i]);
        }
        return encodedValues;
    }

    public Map getParameterMap() {
        Map primary = super.getParameterMap();
        HashMap result = new HashMap(primary.size());
        for (Map.Entry entry : primary.entrySet()) {
            result.put(entry.getKey(), this.filterEntryString((String[])entry.getValue()));
        }
        return result;
    }

    protected String[] filterEntryString(String[] rawValue) {
        for (int i = 0; i < rawValue.length; ++i) {
            rawValue[i] = this.filterParamString(rawValue[i]);
        }
        return rawValue;
    }

    public String getParameter(String parameter) {
        return this.filterParamString(super.getParameter(parameter));
    }

    public String getHeader(String name) {
        return this.filterParamString(super.getHeader(name));
    }

    public Cookie[] getCookies() {
        Cookie[] existingCookies = super.getCookies();
        if (existingCookies != null) {
            for (int i = 0; i < existingCookies.length; ++i) {
                Cookie cookie = existingCookies[i];
                cookie.setValue(this.filterParamString(cookie.getValue()));
            }
        }
        return existingCookies;
    }

    protected String filterParamString(String rawValue) {
        if (null == rawValue) {
            return null;
        }
        String tmpStr = rawValue;
        if (this.filterXSS) {
            tmpStr = WafKit.stripXSS(rawValue);
        }
        if (this.filterSQL) {
            tmpStr = WafKit.stripSqlInjection(tmpStr);
        }
        return tmpStr;
    }
}

