/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.share.cache;

import com.tydic.newretail.toolkit.share.cache.CacheTemplate;
import com.tydic.newretail.toolkit.share.cache.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisPubSubClusterPolicy
extends JedisPubSub {
    private static final Logger log = LoggerFactory.getLogger(RedisPubSubClusterPolicy.class);
    private String channel = "ohaotian-session";
    private JedisPool client;

    public void connect(JedisPool jedisPool) {
        long ct = System.currentTimeMillis();
        this.client = jedisPool;
        try (Jedis jedis = this.client.getResource();){
            jedis.publish(this.channel, Command.join().json());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        new Thread(() -> {
            while (true) {
                try (Jedis jedis = this.client.getResource();){
                    jedis.subscribe((JedisPubSub)this, new String[]{this.channel});
                    log.info("Disconnect to redis channel:" + this.channel);
                    return;
                }
                catch (JedisConnectionException e) {
                    log.error("Failed connect to redis, reconnect it.", (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
        }, "RedisSubscribeThread").start();
        log.info("Connected to redis channel:" + this.channel + ", time " + (System.currentTimeMillis() - ct) + " ms.");
    }

    public void disconnect(JedisPool jedisPool) {
        this.client = jedisPool;
        try (Jedis jedis = this.client.getResource();){
            this.unsubscribe();
            jedis.publish(this.channel, Command.quit().json());
        }
    }

    public void clear(String key) {
        try (Jedis jedis = this.client.getResource();){
            jedis.del(key.getBytes());
        }
        CacheTemplate.getIstance().evict(key);
    }

    public void sendClearCmd(String key) {
        try (Jedis jedis = this.client.getResource();){
            jedis.publish(this.channel, new Command(2, key).json());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6e05\u9664\u7f13\u5b58\u7684\u5e7f\u64ad\u547d\u4ee4 ", (Throwable)e);
        }
    }

    public void onMessage(String channel, String message) {
        try {
            Command cmd = Command.parse(message);
            if (cmd == null || cmd.isLocal()) {
                return;
            }
            switch (cmd.getOperator()) {
                case 1: {
                    log.info("Node-" + cmd.getSrc() + " joined to " + this.channel);
                    break;
                }
                case 2: {
                    CacheTemplate.getIstance().evict(cmd.getKey());
                    log.debug("Received cache clear message, region=" + cmd.getKey());
                    break;
                }
                case 3: {
                    log.info("Node-" + cmd.getSrc() + " quit to " + this.channel);
                    break;
                }
                default: {
                    log.warn("Unknown message type = " + cmd.getOperator());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to handle received msg", (Throwable)e);
        }
    }
}

