/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.share.session;

import com.tydic.newretail.toolkit.share.cache.CacheTemplate;
import com.tydic.newretail.toolkit.share.session.CacheSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.session.SessionRepository;

public class CacheSessionRepository
implements SessionRepository<CacheSession> {
    private static final Logger log = LoggerFactory.getLogger(CacheSessionRepository.class);
    private CacheTemplate cacheTemplate = CacheTemplate.getIstance();
    private static final String REGION = "ZT-SESSIONID";

    public CacheSession createSession() {
        CacheSession session = new CacheSession();
        return session;
    }

    public void save(CacheSession session) {
        if (session == null) {
            return;
        }
        if (session.isNew()) {
            session.setNew(false);
            this.cacheTemplate.set(this.getSessionId(session.getId()), session);
        }
    }

    public CacheSession getSession(String id) {
        log.info("ZTSESSIONID:{}", (Object)id);
        Object o = this.cacheTemplate.get(this.getSessionId(id));
        if (o instanceof CacheSession) {
            CacheSession session = (CacheSession)o;
            log.info(o.toString());
            log.info(session.getCreationTime() + " " + session.getLastAccessedTime() + " " + session.getCreationTime());
            return session;
        }
        return null;
    }

    public void delete(String id) {
        CacheSession session = this.getSession(id);
        if (session == null) {
            return;
        }
        this.cacheTemplate.del(this.getSessionId(id));
    }

    private String getSessionId(String id) {
        return "ZT-SESSIONID:" + id;
    }
}

