/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.jsbridge;

import android.graphics.Bitmap;
import android.os.Build;
import com.github.lzyzsd.jsbridge.BridgeUtil;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.github.lzyzsd.jsbridge.Message;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class BridgeWebViewClient
extends WebViewClient {
    private BridgeWebView webView;

    public BridgeWebViewClient(BridgeWebView webView) {
        this.webView = webView;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (url.startsWith("yy://return/")) {
            this.webView.handlerReturnData(url);
            return true;
        }
        if (url.startsWith("yy://")) {
            this.webView.flushMessageQueue();
            return true;
        }
        return this.onCustomShouldOverrideUrlLoading(url) ? true : super.shouldOverrideUrlLoading(view, url);
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        if (Build.VERSION.SDK_INT >= 24) {
            String url = request.getUrl().toString();
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            if (url.startsWith("yy://return/")) {
                this.webView.handlerReturnData(url);
                return true;
            }
            if (url.startsWith("yy://")) {
                this.webView.flushMessageQueue();
                return true;
            }
            return this.onCustomShouldOverrideUrlLoading(url) ? true : super.shouldOverrideUrlLoading(view, request);
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if ("WebViewJavascriptBridge.js" != null) {
            BridgeUtil.webViewLoadLocalJs(view, "WebViewJavascriptBridge.js");
        }
        if (this.webView.getStartupMessage() != null) {
            for (Message m : this.webView.getStartupMessage()) {
                this.webView.dispatchMessage(m);
            }
            this.webView.setStartupMessage(null);
        }
        this.onCustomPageFinishd(view, url);
    }

    protected boolean onCustomShouldOverrideUrlLoading(String url) {
        return false;
    }

    protected void onCustomPageFinishd(WebView view, String url) {
    }
}

