/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.webview;

import android.content.Context;
import android.net.Uri;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.github.lzyzsd.jsbridge.BridgeWebViewClient;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.github.lzyzsd.jsbridge.DefaultHandler;
import com.tencent.smtt.export.external.interfaces.SslError;
import com.tencent.smtt.export.external.interfaces.SslErrorHandler;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.ValueCallback;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tydic.newretail.webview.interfaces.IOnWebviewFinishInterface;
import com.tydic.newretail.webview.interfaces.JsFunction;
import com.tydic.newretail.webview.interfaces.NativeHandler;
import java.util.ArrayList;
import java.util.HashMap;

public class BridgeInterfaceProcess {
    public static boolean showLog = false;
    public static IOnWebviewFinishInterface iOnWebviewFinishInterface;
    private static BridgeInterfaceProcess bridgeInterfaceProcess;
    private static BridgeInterfaceProcess bridgeInterfaceProcess2;
    private Context context;
    private BridgeWebView mWebView;
    private String url;
    private HashMap<String, JsFunction> jsFunctionHashMap = new HashMap();
    private ArrayList<NativeHandler> nativeHandlerList = new ArrayList();
    private static HashMap<Object, BridgeInterfaceProcess> bridgeInterfaceProcessInstances;

    public static BridgeInterfaceProcess getInstance() {
        return bridgeInterfaceProcess;
    }

    public static BridgeInterfaceProcess getInstance(Context context, BridgeWebView webView, String url) {
        if (bridgeInterfaceProcess == null) {
            bridgeInterfaceProcess = new BridgeInterfaceProcess(context, webView, url);
        }
        return bridgeInterfaceProcess;
    }

    public static BridgeInterfaceProcess getInstance2() {
        return bridgeInterfaceProcess2;
    }

    public static BridgeInterfaceProcess getInstance2(Context context, BridgeWebView webView, String url) {
        if (bridgeInterfaceProcess2 == null) {
            bridgeInterfaceProcess2 = new BridgeInterfaceProcess(context, webView, url);
        }
        return bridgeInterfaceProcess2;
    }

    public BridgeInterfaceProcess() {
    }

    public BridgeInterfaceProcess(Context context, BridgeWebView webView, String url) {
        this.context = context;
        this.mWebView = webView;
        this.url = url;
    }

    public void initWebView() {
        WebSettings settings = this.mWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setCacheMode(2);
        settings.setDomStorageEnabled(true);
        String appCachePath = this.context.getApplicationContext().getCacheDir().getAbsolutePath();
        settings.setAppCachePath(appCachePath);
        settings.setAllowFileAccess(true);
        settings.setAppCacheEnabled(true);
        settings.setMixedContentMode(0);
        this.mWebView.setWebViewClient(new MyWebViewClient(this.mWebView));
        this.mWebView.setDefaultHandler(new myHadlerCallBack());
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType, String capture) {
                this.openFileChooser(uploadMsg);
            }

            public void openFileChooser(ValueCallback<Uri> uploadMsg, String AcceptType) {
                this.openFileChooser(uploadMsg);
            }

            public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            }
        });
        for (NativeHandler nativeHandler : this.nativeHandlerList) {
            nativeHandler.register();
        }
        this.mWebView.loadUrl(this.url);
    }

    public void setJSFunction(String tag, JsFunction jsFunction) {
        this.jsFunctionHashMap.put(tag, jsFunction);
    }

    public JsFunction getJSFunction(String functionName) {
        return this.jsFunctionHashMap.get(functionName);
    }

    public void setNativeHandler(NativeHandler nativeHandler) {
        this.nativeHandlerList.add(nativeHandler);
    }

    public static BridgeInterfaceProcess getNewInstance(Object tag, Context context, BridgeWebView webView, String url) {
        BridgeInterfaceProcess instance = null;
        if (bridgeInterfaceProcessInstances == null) {
            bridgeInterfaceProcessInstances = new HashMap();
        } else {
            instance = bridgeInterfaceProcessInstances.get(tag);
        }
        if (instance == null) {
            instance = new BridgeInterfaceProcess(context, webView, url);
            bridgeInterfaceProcessInstances.put(tag, instance);
        }
        return instance;
    }

    public static BridgeInterfaceProcess getOneExtInstance(Object o) {
        return bridgeInterfaceProcessInstances.get(o);
    }

    static {
        bridgeInterfaceProcessInstances = new HashMap();
    }

    class myHadlerCallBack
    extends DefaultHandler {
        myHadlerCallBack() {
        }

        @Override
        public void handler(String data, CallBackFunction function) {
            if (function != null) {
                function.onCallBack("0000");
            }
        }
    }

    class MyWebViewClient
    extends BridgeWebViewClient {
        public MyWebViewClient(BridgeWebView webView) {
            super(webView);
        }

        public MyWebViewClient(BridgeWebView webView, IOnWebviewFinishInterface iOnWebviewFinishInterface1) {
            super(webView);
            iOnWebviewFinishInterface = iOnWebviewFinishInterface1;
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return super.shouldOverrideUrlLoading(view, url);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            view.invalidate();
            if (iOnWebviewFinishInterface != null) {
                iOnWebviewFinishInterface.webviewFinish();
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
        }

        public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
            super.onReceivedError(webView, webResourceRequest, webResourceError);
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            sslErrorHandler.proceed();
        }
    }
}

