/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.export.external;

import android.content.Context;
import android.os.Build;
import java.io.File;
import java.util.ArrayList;

public class LibraryLoader {
    private static String[] sLibrarySearchPaths = null;

    public static String[] getLibrarySearchPaths(Context context) {
        if (sLibrarySearchPaths != null) {
            return sLibrarySearchPaths;
        }
        if (context == null) {
            String[] stringArray = new String[]{"/system/lib"};
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(LibraryLoader.getNativeLibraryDir(context));
        arrayList.add("/system/lib");
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        sLibrarySearchPaths = stringArray;
        return sLibrarySearchPaths;
    }

    public static String getNativeLibraryDir(Context context) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 9) {
            return context.getApplicationInfo().nativeLibraryDir;
        }
        if (n2 >= 4) {
            return context.getApplicationInfo().dataDir + "/lib";
        }
        return "/data/data/" + context.getPackageName() + "/lib";
    }

    public static void loadLibrary(Context context, String string) {
        String[] stringArray = LibraryLoader.getLibrarySearchPaths(context);
        String string2 = System.mapLibraryName(string);
        for (String string3 : stringArray) {
            if (!new File(string3 = string3 + "/" + string2).exists()) continue;
            try {
                System.load(string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            System.loadLibrary(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

