/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.oss;

import com.tydic.nicc.dc.boot.starter.oss.OssConfigBean;
import com.tydic.nicc.dc.boot.starter.oss.OssHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"nicc-dc-config.oss.enable"}, matchIfMissing=true, havingValue="true")
@Configuration
public class OssFileConfig {
    private static final Logger logger = LoggerFactory.getLogger(OssFileConfig.class);
    @Value(value="${nicc-dc-config.oss.endpoint}")
    private String endpoint;
    @Value(value="${nicc-dc-config.oss.accesskey}")
    private String accesskey;
    @Value(value="${nicc-dc-config.oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${nicc-dc-config.oss.bucketName}")
    private String bucketName;
    @Value(value="${nicc-dc-config.oss.accessUrl}")
    private String accessUrl;

    @Bean
    public OssConfigBean getOssConfig() {
        logger.info("\u52a0\u8f7d OSS \u914d\u7f6e:endpoint:{}, accesskey:{},bucketName:{}, accessUrl:{}", new Object[]{this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl});
        return new OssConfigBean(this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl);
    }

    @Bean
    public OssHelper fileClient() {
        logger.info("\u521d\u59cb\u5316 OSS \u914d\u7f6e...\u5f00\u59cb");
        if (this.getOssConfig().check()) {
            logger.info("\u521d\u59cb\u5316 OSS \u914d\u7f6e...\u5b8c\u6210");
            return new OssHelper(this.getOssConfig());
        }
        throw new IllegalArgumentException("OSS \u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccesskey() {
        return this.accesskey;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssFileConfig)) {
            return false;
        }
        OssFileConfig other = (OssFileConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accesskey = this.getAccesskey();
        String other$accesskey = other.getAccesskey();
        if (this$accesskey == null ? other$accesskey != null : !this$accesskey.equals(other$accesskey)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$accessUrl = this.getAccessUrl();
        String other$accessUrl = other.getAccessUrl();
        return !(this$accessUrl == null ? other$accessUrl != null : !this$accessUrl.equals(other$accessUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OssFileConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accesskey = this.getAccesskey();
        result = result * 59 + ($accesskey == null ? 43 : $accesskey.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $accessUrl = this.getAccessUrl();
        result = result * 59 + ($accessUrl == null ? 43 : $accessUrl.hashCode());
        return result;
    }

    public String toString() {
        return "OssFileConfig(endpoint=" + this.getEndpoint() + ", accesskey=" + this.getAccesskey() + ", accessKeySecret=" + this.getAccessKeySecret() + ", bucketName=" + this.getBucketName() + ", accessUrl=" + this.getAccessUrl() + ")";
    }
}

