/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.ftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.tydic.nicc.dc.boot.starter.ftp.FtpConfigBean;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPHelper
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SFTPHelper.class);
    private Session session;
    private ChannelSftp channelSftp;
    private FtpConfigBean ftpConfigBean;
    private String homeDir;
    private static final int TIMEOUT = 60000;
    private static final int BYTE_LENGTH = 1024;

    public SFTPHelper(FtpConfigBean ftpConfig) {
        try {
            this.ftpConfigBean = ftpConfig;
            this.homeDir = ftpConfig.getHomeDir().lastIndexOf("/") != -1 ? ftpConfig.getHomeDir() : ftpConfig.getHomeDir() + File.separator;
            JSch jSch = new JSch();
            this.session = jSch.getSession(ftpConfig.getUsername(), ftpConfig.getHost(), ftpConfig.getPort().intValue());
            if (null != ftpConfig.getPassword()) {
                this.session.setPassword(ftpConfig.getPassword());
            }
            this.session.setTimeout(60000);
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            this.session.setConfig(properties);
        }
        catch (Exception e) {
            log.error("init ftpConfig error:{}", (Object)ftpConfig, (Object)e);
        }
    }

    public SFTPHelper(String userName, String password, String host) {
        try {
            String[] arr = host.split(":");
            String ip = arr[0];
            int port = arr.length > 1 ? Integer.parseInt(arr[1]) : 22;
            JSch jSch = new JSch();
            this.session = jSch.getSession(userName, ip, port);
            if (null != password) {
                this.session.setPassword(password);
            }
            this.session.setTimeout(60000);
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            this.session.setConfig(properties);
        }
        catch (Exception e) {
            log.error("init host:{},userName:{},password:{} error:{}", new Object[]{host, userName, password, e});
        }
    }

    public ChannelSftp getFtpChannel() {
        return this.channelSftp;
    }

    public boolean connection() {
        try {
            if (!this.isConnected()) {
                this.session.connect();
                this.channelSftp = (ChannelSftp)this.session.openChannel("sftp");
                this.channelSftp.connect();
                log.info("connected to host:{},userName:{}", (Object)this.session.getHost(), (Object)this.session.getUserName());
            }
            return true;
        }
        catch (JSchException e) {
            log.error("connection to sftp host:{} error:{}", (Object)this.session.getHost(), (Object)e);
            return false;
        }
    }

    private boolean get(String remoteFile, String localPath) {
        if (this.isConnected()) {
            try {
                this.channelSftp.get(remoteFile, localPath);
                return true;
            }
            catch (SftpException e) {
                log.error("get remoteFile:{},localPath:{}, error:{}", new Object[]{remoteFile, localPath, e});
            }
        }
        return false;
    }

    private byte[] getFileByte(String remoteFile) {
        byte[] fileData;
        try (InputStream inputStream = this.channelSftp.get(remoteFile);){
            byte[] ss = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int rc = 0;
            while ((rc = inputStream.read(ss, 0, 1024)) > 0) {
                byteArrayOutputStream.write(ss, 0, rc);
            }
            fileData = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.error("getFileData remoteFile:{},error:{}", (Object)remoteFile, (Object)e);
            fileData = null;
        }
        return fileData;
    }

    private List<String> getFileLines(String remoteFile, String charsetName) {
        ArrayList<String> fileData;
        try (InputStream inputStream = this.channelSftp.get(remoteFile);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charsetName);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String str;
            fileData = new ArrayList<String>();
            while ((str = bufferedReader.readLine()) != null) {
                fileData.add(str);
            }
        }
        catch (Exception e) {
            log.error("getFileData remoteFile:{},error:{}", (Object)remoteFile, (Object)e);
            fileData = null;
        }
        return fileData;
    }

    private boolean put(String localFile, String remoteFile) {
        if (this.isConnected()) {
            try {
                log.info("put file: localPath = {},remotePath = {},workDir = {}", new Object[]{localFile, remoteFile, this.channelSftp.pwd()});
                this.channelSftp.put(localFile, remoteFile);
                return true;
            }
            catch (SftpException e) {
                log.error("put localPath:{}, remoteFile:{},error:{}", new Object[]{localFile, remoteFile, e});
                return false;
            }
        }
        return false;
    }

    private boolean put(File file, String remoteFile) {
        if (this.isConnected()) {
            try {
                this.channelSftp.put((InputStream)new FileInputStream(file), remoteFile);
                return true;
            }
            catch (SftpException e) {
                log.error("put localPath:{}, remoteFile:{},error:{}", new Object[]{file.getName(), remoteFile, e});
                return false;
            }
            catch (FileNotFoundException e) {
                log.error("put localPath:{}, remoteFile:{},error:{}", new Object[]{file.getName(), remoteFile, e});
                return false;
            }
        }
        return false;
    }

    private boolean put(InputStream inputStream, String remoteFile) {
        if (this.isConnected()) {
            try {
                this.channelSftp.put(inputStream, remoteFile);
                return true;
            }
            catch (SftpException e) {
                log.error("put inputStream, remoteFile:{},error:{}", (Object)remoteFile, (Object)e);
                return false;
            }
        }
        return false;
    }

    private boolean delFile(String remoteFile) {
        if (this.isConnected()) {
            try {
                this.channelSftp.rm(remoteFile);
                return true;
            }
            catch (SftpException e) {
                log.error("delFile remoteFile:{} , error:{}", (Object)remoteFile, (Object)e);
            }
        }
        return false;
    }

    private Vector ls(String remotePath) {
        Vector vector = null;
        if (this.isConnected()) {
            try {
                vector = this.channelSftp.ls(remotePath);
            }
            catch (SftpException e) {
                vector = null;
                log.error("ls remotePath:{} , error:{}", (Object)remotePath, (Object)e);
            }
        }
        return vector;
    }

    private List<ChannelSftp.LsEntry> lsFiles(String remotePath, Pattern filenamePattern) {
        List lsEntryList = null;
        if (this.isConnected()) {
            try {
                Vector vector = this.channelSftp.ls(remotePath);
                if (vector != null) {
                    lsEntryList = vector.stream().filter(x -> {
                        boolean match = true;
                        if (filenamePattern != null) {
                            Matcher mtc = filenamePattern.matcher(x.getFilename());
                            match = mtc.find();
                        }
                        return match && !x.getAttrs().isDir() && !x.getAttrs().isLink();
                    }).collect(Collectors.toList());
                }
            }
            catch (SftpException e) {
                lsEntryList = null;
                log.error("lsFiles remotePath:{} , error:{}", (Object)remotePath, (Object)e);
            }
        }
        return lsEntryList;
    }

    public boolean isConnected() {
        if (this.session.isConnected() && this.channelSftp.isConnected()) {
            return true;
        }
        log.info("sftp server:{} is not connected", (Object)this.session.getHost());
        return false;
    }

    @Override
    public void close() {
        if (this.channelSftp != null && this.channelSftp.isConnected()) {
            this.channelSftp.quit();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        log.info("sftp session and channel is closed");
    }

    public boolean uploadFile(String localPath, String targetPath, String fileName) {
        File file;
        if (this.connection() && (file = new File(localPath)).exists()) {
            if (fileName == null || fileName.equals("")) {
                fileName = file.getName();
            }
            String remotePath = this.homeDir + targetPath + File.separator + file.getName();
            this.put(localPath, remotePath);
            return true;
        }
        return false;
    }

    public boolean uploadBatchFile(List<String> localPathList, String targetPath) {
        if (this.connection()) {
            for (String filePath : localPathList) {
                File file = new File(filePath);
                if (!file.exists()) continue;
                String remotePath = this.homeDir + targetPath + File.separator + file.getName();
                log.debug("SFTPHelper uploadBatchFile localPath = {},remotePath = {}", (Object)filePath, (Object)remotePath);
                this.put(filePath, remotePath);
                return true;
            }
        }
        return false;
    }

    public boolean uploadFile(InputStream inputStream, String targetFileName) {
        if (this.connection()) {
            String remotePath = this.homeDir + targetFileName;
            log.debug("SFTPHelper uploadFile remotePath = {}", (Object)remotePath);
            return this.put(inputStream, remotePath);
        }
        return false;
    }

    public boolean downloadFile(String targetFileName, String localPath) {
        if (this.connection()) {
            String remotePath = this.homeDir + targetFileName;
            log.debug("SFTPHelper getFile remotePath = {},localPath = {}", (Object)remotePath, (Object)localPath);
            return this.get(remotePath, localPath);
        }
        return false;
    }

    private InputStream downloadFile(String targetFileName) {
        if (this.isConnected()) {
            try {
                String remotePath = this.homeDir + targetFileName;
                log.error("SFTPHelper downloadFile remotePath = {}", (Object)remotePath);
                return this.channelSftp.get(remotePath);
            }
            catch (SftpException e) {
                log.error("SFTPHelper downloadFile:", (Throwable)e);
            }
        }
        return null;
    }

    public boolean deleteFile(String targetFileName) {
        if (this.connection()) {
            String remotePath = this.homeDir + targetFileName;
            log.debug("SFTPHelper deleteFile remotePath = {}", (Object)remotePath);
            return this.delFile(remotePath);
        }
        return false;
    }

    public int deleteFile(List<String> targetFileNames) {
        int count = 0;
        if (this.connection()) {
            if (targetFileNames.isEmpty()) {
                return count;
            }
            for (String targetFileName : targetFileNames) {
                String remotePath = this.homeDir + targetFileName;
                boolean f = this.delFile(remotePath);
                log.debug("SFTPHelper deleteFile remotePath = {}, result = {}", (Object)remotePath, (Object)f);
                if (!f) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean changeDir(String targetPath) {
        if (this.connection()) {
            try {
                log.info("changeDir: cd {},workDir {}", (Object)this.homeDir, (Object)this.channelSftp.pwd());
                if (StringUtils.isEmpty((CharSequence)this.homeDir) || "~".equals(targetPath)) {
                    this.channelSftp.cd(this.homeDir);
                } else {
                    this.channelSftp.cd(targetPath);
                }
                log.info("changeDir: workDir {}", (Object)this.channelSftp.pwd());
                return true;
            }
            catch (SftpException e) {
                log.error("SFTPHelper changeDir:", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public boolean mkdir(String targetPath) {
        if (this.connection()) {
            try {
                this.channelSftp.cd(this.homeDir);
                log.info("SFTPHelper: cd {}", (Object)this.homeDir);
                log.info("SFTPHelper: mkdir {},workDir {}", (Object)targetPath, (Object)this.channelSftp.pwd());
                Vector vector = this.channelSftp.ls("./");
                if (vector.contains(targetPath)) {
                    log.warn("\u76ee\u5f55\u5df2\u5b58\u5728!");
                } else {
                    this.channelSftp.mkdir(targetPath);
                }
                return true;
            }
            catch (SftpException e) {
                log.error("SFTPHelper mkdir:", (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

