/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.rocketmq.consumer;

import com.tydic.nicc.dc.boot.starter.rocketmq.consumer.ConsumerService;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQConsumer
extends DefaultMQPushConsumer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQConsumer.class);

    public RocketMQConsumer(String consumerGroup, String topic, String subExpression) {
        super(consumerGroup);
        try {
            super.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            log.error("rocketmq subcribe topic failure", (Throwable)e);
        }
    }

    public void setConsumerHandler(ConsumerService consumerService) {
        super.registerMessageListener((msgs, consumeConcurrentlyContext) -> {
            MessageExt msg = (MessageExt)msgs.get(0);
            try {
                if (consumerService.consume((Message)msg)) {
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
            catch (Throwable e) {
                log.error("consume message error", e);
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
        });
    }

    public void start() {
        try {
            super.start();
        }
        catch (MQClientException e) {
            log.error("rocketmq start consumer error", (Throwable)e);
        }
    }

    public void shutdown() {
        super.shutdown();
    }
}

