/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.ftp;

import com.tydic.nicc.dc.boot.starter.ftp.FtpConfigBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPHelper {
    private FTPClient ftpClient;
    private FtpConfigBean ftpConfig;
    private static Logger logger = LoggerFactory.getLogger(FTPHelper.class);

    public FTPHelper(FtpConfigBean ftpConfig) {
        this.ftpConfig = ftpConfig;
    }

    public boolean makeDirectory(String remotePath, String makePath) {
        try {
            FTPClient ftpClient = this.loginFtp();
            boolean changeResult = ftpClient.changeWorkingDirectory(remotePath);
            if (!changeResult) {
                throw new RuntimeException("\u5207\u6362\u76ee\u5f55\u5931\u8d25");
            }
            boolean result = ftpClient.makeDirectory(makePath);
            ftpClient.logout();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean moveFile(String fromPath, String fromName, String toPath, String toName) {
        try {
            FTPClient ftpClient = this.loginFtp();
            boolean changeResult = ftpClient.changeWorkingDirectory(fromPath);
            if (!changeResult) {
                throw new RuntimeException("\u5207\u6362\u76ee\u5f55\u5931\u8d25");
            }
            boolean result = ftpClient.rename(fromName, toPath + File.separator + toName);
            ftpClient.logout();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteFile(String remotePath, String fileName) {
        try {
            FTPClient ftpClient = this.loginFtp();
            boolean changeResult = ftpClient.changeWorkingDirectory(remotePath);
            if (!changeResult) {
                throw new RuntimeException("\u5207\u6362\u76ee\u5f55\u5931\u8d25");
            }
            boolean result = ftpClient.deleteFile(fileName);
            ftpClient.logout();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean download(String remotePath, String fileName, String localPath, String localName) {
        try {
            boolean createFileResult;
            boolean mkdirsResult;
            FTPClient ftpClient = this.loginFtp();
            boolean changeResult = ftpClient.changeWorkingDirectory(remotePath);
            if (!changeResult) {
                throw new RuntimeException("\u5207\u6362\u76ee\u5f55\u5931\u8d25");
            }
            ftpClient.setFileType(2);
            File file = new File(localPath, localName);
            if (!file.getParentFile().exists() && !(mkdirsResult = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25");
            }
            if (!file.exists() && !(createFileResult = file.createNewFile())) {
                throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            boolean result = ftpClient.retrieveFile(fileName, (OutputStream)outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
            ftpClient.logout();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean uploadFile(InputStream inputStream, String remotePath, String fileName) {
        try {
            logger.debug("\u4e0a\u4f20\u6587\u4ef6:remotePath = {},fileName = {}", (Object)remotePath, (Object)fileName);
            FTPClient ftpClient = this.loginFtp();
            boolean changeResult = ftpClient.changeWorkingDirectory(remotePath);
            if (!changeResult) {
                throw new RuntimeException("\u5207\u6362\u76ee\u5f55\u5931\u8d25!");
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileTransferMode(10);
            ftpClient.setFileType(2);
            boolean result = ftpClient.storeFile(fileName, inputStream);
            inputStream.close();
            ftpClient.logout();
            return result;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 IOException\uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean uploadFile(String localPath, String remotePath, String fileName) {
        return this.uploadFile(new File(localPath), remotePath, fileName);
    }

    public boolean uploadFile(File file, String remotePath, String fileName) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            String name = "";
            if (fileName == null || "".equals(fileName)) {
                name = file.getName();
            }
            boolean result = this.uploadFile(inputStream, remotePath, name);
            return result;
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 FileNotFoundException\uff1a", (Throwable)e);
            return false;
        }
    }

    private FTPClient loginFtp() throws IOException {
        FTPClient ftpClient = this.getClient();
        ftpClient.connect(this.ftpConfig.getHost(), this.ftpConfig.getPort().intValue());
        ftpClient.login(this.ftpConfig.getUsername(), this.ftpConfig.getPassword());
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftpClient.disconnect();
        }
        ftpClient.setControlEncoding("GBK");
        return ftpClient;
    }

    private FTPClient getClient() {
        if (this.ftpClient != null) {
            return this.ftpClient;
        }
        return new FTPClient();
    }
}

