/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.ftp;

import com.tydic.nicc.dc.boot.starter.ftp.FTPHelper;
import com.tydic.nicc.dc.boot.starter.ftp.FtpConfigBean;
import com.tydic.nicc.dc.boot.starter.ftp.SFTPHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"nicc-dc-config.ftp.enable"}, matchIfMissing=true, havingValue="true")
@Configuration
public class SFtpConfigure {
    private static final Logger logger = LoggerFactory.getLogger(SFtpConfigure.class);
    @Value(value="${nicc-dc-config.ftp.type}")
    private String type;
    @Value(value="${nicc-dc-config.ftp.host}")
    private String host;
    @Value(value="${nicc-dc-config.ftp.port}")
    private Integer port;
    @Value(value="${nicc-dc-config.ftp.username}")
    private String username;
    @Value(value="${nicc-dc-config.ftp.password}")
    private String password;
    @Value(value="${nicc-dc-config.ftp.homeDir}")
    private String homeDir;

    @Bean
    public FtpConfigBean ftpConfigBeanBuilder() {
        logger.info("\u52a0\u8f7d FTP \u914d\u7f6e:type:{}, host:{}, port:{},username:{}, homeDir:{}", new Object[]{this.type, this.host, this.port, this.username, this.homeDir});
        return new FtpConfigBean(this.type, this.host, this.port, this.username, this.password, this.homeDir);
    }

    @ConditionalOnProperty(value={"nicc-dc-config.ftp.type"}, havingValue="sftp")
    @Bean
    public SFTPHelper sftpHelperBuilder() {
        logger.info("\u521d\u59cb\u5316 SFTP \u914d\u7f6e...\u5f00\u59cb");
        if (this.ftpConfigBeanBuilder().check()) {
            logger.info("\u521d\u59cb\u5316 SFTP \u914d\u7f6e...\u5b8c\u6210");
            return new SFTPHelper(this.ftpConfigBeanBuilder());
        }
        throw new IllegalArgumentException("FTP\u7ec4\u4ef6\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
    }

    @ConditionalOnProperty(value={"nicc-dc-config.ftp.type"}, havingValue="ftp")
    @Bean
    public FTPHelper ftpHelperBuilder() {
        logger.info("\u521d\u59cb\u5316 FTP \u914d\u7f6e...\u5f00\u59cb");
        if (this.ftpConfigBeanBuilder().check()) {
            logger.info("\u521d\u59cb\u5316 FTP \u914d\u7f6e...\u5b8c\u6210");
            return new FTPHelper(this.ftpConfigBeanBuilder());
        }
        throw new IllegalArgumentException("FTP\u7ec4\u4ef6\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
    }

    public String getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SFtpConfigure)) {
            return false;
        }
        SFtpConfigure other = (SFtpConfigure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$homeDir = this.getHomeDir();
        String other$homeDir = other.getHomeDir();
        return !(this$homeDir == null ? other$homeDir != null : !this$homeDir.equals(other$homeDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SFtpConfigure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $homeDir = this.getHomeDir();
        result = result * 59 + ($homeDir == null ? 43 : $homeDir.hashCode());
        return result;
    }

    public String toString() {
        return "SFtpConfigure(type=" + this.getType() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", homeDir=" + this.getHomeDir() + ")";
    }
}

