/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.rocketmq.producer;

import com.tydic.nicc.dc.boot.starter.rocketmq.producer.ProducerService;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQProducer
extends DefaultMQProducer
implements ProducerService {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducer.class);

    public RocketMQProducer() {
    }

    public RocketMQProducer(String producerGroup) {
        super(producerGroup);
    }

    public void shutdown() {
        super.shutdown();
    }

    public void start() {
        try {
            super.start();
        }
        catch (MQClientException e) {
            log.error("rocketmq start producer error", (Throwable)e);
        }
    }

    @Override
    public SendResult sendMessage(Message msg) {
        try {
            return this.send(msg);
        }
        catch (Exception e) {
            log.error("rocketmq send message error", (Throwable)e);
            return null;
        }
    }

    @Override
    public SendResult sendMessage(Message msg, long timeout) {
        try {
            return this.send(msg, timeout);
        }
        catch (Exception e) {
            log.error("rocketmq send message error", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean sendMessage(Message msg, int repeatTimes) {
        boolean result = false;
        for (int count = 0; count < repeatTimes; ++count) {
            SendResult sendResult = this.sendMessage(msg);
            log.debug("send message,result:" + sendResult.getSendStatus());
            if (sendResult == null || SendStatus.SEND_OK != sendResult.getSendStatus()) continue;
            result = true;
            break;
        }
        return result;
    }
}

