/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtil {
    private static Logger logger = LoggerFactory.getLogger(DateTimeUtil.class);
    private static final int ONE_HH_SS = 3600;
    private static final int ONE_MM_SS = 60;
    public static final String TIME_FORMAT_SHORT = "yyyyMMddHHmmss";
    public static final String TIME_FORMAT_SHORT_HOUR = "yyyyMMddHH";
    public static final String TIME_FORMAT_SHORT_MM = "yyyyMMddHHmm";
    public static final String TIME_FORMAT_YMD = "yyyy/MM/dd HH:mm:ss";
    public static final String TIME_FORMAT_NORMAL = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_FORMAT_ENGLISH = "MM/dd/yyyy HH:mm:ss";
    public static final String TIME_FORMAT_CHINA = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static final String TIME_FORMAT_CHINA_M = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206";
    public static final String TIME_FORMAT_CHINA_S = "yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2";
    public static final String TIME_FORMAT_SHORT_S = "HH:mm:ss";
    public static final String DATE_FORMAT_SHORT = "yyyyMMdd";
    public static final String DATE_FORMAT_NORMAL = "yyyy-MM-dd";
    public static final String DATE_FORMAT_ENGLISH = "MM/dd/yyyy";
    public static final String DATE_FORMAT_CHINA = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_FORMAT_CHINA_YEAR_MONTH = "yyyy\u5e74MM\u6708";
    public static final String MONTH_FORMAT = "yyyyMM";
    public static final String YEAR_MONTH_FORMAT = "yyyy-MM";
    public static final String DATE_FORMAT_MINUTE = "yyyyMMddHHmm";
    public static final String MONTH_DAY_FORMAT = "MM-dd";
    public static final String YEAR_FORMAT = "yyyy";
    public static final String TIME_FORMAT_TIME = "yyyy/MM/dd HH:mm";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat sdfTimes = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final SimpleDateFormat sdfTChina = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");

    public static Date convertAsDate(String dateStr) {
        if (dateStr == null || "".equals(dateStr.trim())) {
            return null;
        }
        SimpleDateFormat fmt = null;
        fmt = dateStr.matches("\\d{14}") ? new SimpleDateFormat(TIME_FORMAT_SHORT) : (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}") ? new SimpleDateFormat(TIME_FORMAT_NORMAL) : (dateStr.matches("\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}") ? new SimpleDateFormat(TIME_FORMAT_ENGLISH) : (dateStr.matches("\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2") ? new SimpleDateFormat(TIME_FORMAT_CHINA) : (dateStr.matches("\\d{8}") ? new SimpleDateFormat(DATE_FORMAT_SHORT) : (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}") ? new SimpleDateFormat(DATE_FORMAT_NORMAL) : (dateStr.matches("\\d{1,2}/\\d{1,2}/\\d{4}") ? new SimpleDateFormat(DATE_FORMAT_ENGLISH) : (dateStr.matches("\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5") ? new SimpleDateFormat(DATE_FORMAT_CHINA) : (dateStr.matches("\\d{4}\\d{1,2}\\d{1,2}\\d{1,2}\\d{1,2}") ? new SimpleDateFormat("yyyyMMddHHmm") : (dateStr.matches("\\d{1,2}:\\d{1,2}:\\d{1,2}") ? new SimpleDateFormat(TIME_FORMAT_SHORT_S) : new SimpleDateFormat(TIME_FORMAT_NORMAL))))))))));
        try {
            return fmt.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date convertAsDate(String dateStr, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        try {
            return fmt.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getTimeShortString(Date date) {
        return new SimpleDateFormat(TIME_FORMAT_SHORT).format(date);
    }

    public static String getTimeShortString(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static long getTenTimeByDate(Date date) {
        return date.getTime() / 1000L;
    }

    public static long getTenTimeByDate(String dateStr) {
        return DateTimeUtil.convertAsDate(dateStr).getTime() / 1000L;
    }

    public static boolean latterThan(String strFirst, String strSecond, String strFormat) {
        SimpleDateFormat ft = new SimpleDateFormat(strFormat);
        try {
            Date date1 = ft.parse(strFirst);
            Date date2 = ft.parse(strSecond);
            long quot = date2.getTime() - date1.getTime();
            return 0L < quot;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int differYear(String firstTime, String secondTime) {
        Date beginTime = null;
        Date endTime = null;
        try {
            beginTime = new SimpleDateFormat(DATE_FORMAT_NORMAL).parse(firstTime);
            endTime = new SimpleDateFormat(DATE_FORMAT_NORMAL).parse(secondTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        GregorianCalendar startCalendar = new GregorianCalendar();
        startCalendar.setTime(beginTime);
        GregorianCalendar endCalendar = new GregorianCalendar();
        endCalendar.setTime(endTime);
        int diffYear = endCalendar.get(1) - startCalendar.get(1);
        Date timeBegin = null;
        Date timeEnd = null;
        try {
            timeBegin = new SimpleDateFormat(DATE_FORMAT_NORMAL).parse("2019" + firstTime.substring(4));
            timeEnd = new SimpleDateFormat(DATE_FORMAT_NORMAL).parse("2019" + secondTime.substring(4));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (timeBegin.getTime() > timeEnd.getTime()) {
            --diffYear;
        }
        return diffYear;
    }

    public static int ShortTimeToMs(String shortTime) {
        int ms = 0;
        if (shortTime == null) {
            return ms;
        }
        String[] hms = shortTime.trim().split(":");
        try {
            int hh = Integer.valueOf(hms[0]);
            int mm = Integer.valueOf(hms[1]);
            int ss = Integer.valueOf(hms[2]);
            ms = (hh * 3600 + mm * 60 + ss) * 1000;
            return ms;
        }
        catch (Exception e) {
            logger.error("shortTime = {} ,\u65f6\u95f4\u4e0d\u5408\u6cd5\uff1a{}", (Object)shortTime, (Object)e.getMessage());
            return ms;
        }
    }

    public static String MsToShortTime(Integer ms) {
        if (ms == null) {
            return "";
        }
        String shortTime = "";
        int ss = ms / 1000;
        int res = ss % 3600;
        int hh = 0;
        String hhStr = "";
        hh = ss / 3600;
        hhStr = hh < 10 ? "0" + hh : "" + hh;
        if (res == 0) {
            shortTime = hhStr + ":00:00";
        } else {
            int mm = 0;
            String mmStr = "";
            int res1 = res % 60;
            mm = res / 60;
            mmStr = mm < 10 ? "0" + mm : "" + mm;
            shortTime = res1 == 0 ? hhStr + ":" + mmStr + ":00" : (res1 < 10 ? hhStr + ":" + mmStr + ":0" + res1 : hhStr + ":" + mmStr + ":" + res1);
        }
        return shortTime;
    }
}

