/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.util;

import com.tydic.nicc.dc.base.bo.DcRsp;
import com.tydic.nicc.dc.base.bo.DcRspList;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import java.util.List;

public class DcRspUtils {
    public static final String SUCCESS_DESC = "\u4e1a\u52a1\u5904\u7406\u6210\u529f!";

    private DcRspUtils() {
    }

    public static DcRsp createSuccessRsp(Object data) {
        DcRsp dcRsp = new DcRsp();
        dcRsp.setData(data);
        dcRsp.setRspCode("0000");
        dcRsp.setRspDesc(SUCCESS_DESC);
        return dcRsp;
    }

    public static DcRsp createSuccessRsp(Object data, String msg) {
        DcRsp dcRsp = new DcRsp();
        dcRsp.setData(data);
        dcRsp.setRspCode("0000");
        dcRsp.setRspDesc(msg);
        return dcRsp;
    }

    public static DcRsp createErrorRsp(String errCode, String errMsg) {
        DcRsp dcRsp = new DcRsp();
        dcRsp.setRspCode(errCode);
        dcRsp.setRspDesc(errMsg);
        return dcRsp;
    }

    public static DcRsp createErrorRsp(Object data, String errMsg) {
        DcRsp dcRsp = new DcRsp();
        dcRsp.setRspCode("8888");
        dcRsp.setRspDesc(errMsg);
        return dcRsp;
    }

    public static DcRsp createErrorRsp(String errMsg) {
        DcRsp dcRsp = new DcRsp();
        dcRsp.setRspCode("8888");
        dcRsp.setRspDesc(errMsg);
        return dcRsp;
    }

    public static DcRsp createErrorRsp(DcBusinessException e) {
        DcRsp dcRsp = new DcRsp();
        dcRsp.setRspCode(e.getErrorCode());
        dcRsp.setRspDesc(e.getMessage());
        return dcRsp;
    }

    public static DcRspList createSuccessRspList(List<?> data) {
        DcRspList rsp = new DcRspList();
        rsp.setRows(data);
        rsp.setCount((long)data.size());
        rsp.setRspCode("0000");
        rsp.setRspDesc(SUCCESS_DESC);
        return rsp;
    }

    public static DcRspList createSuccessRspList(List<?> data, long count) {
        DcRspList rsp = new DcRspList();
        rsp.setRows(data);
        rsp.setCount(count);
        rsp.setRspCode("0000");
        rsp.setRspDesc(SUCCESS_DESC);
        return rsp;
    }

    public static DcRspList createErrorRspList(String errCode, String errMsg) {
        DcRspList rsp = new DcRspList();
        rsp.setRspCode(errCode);
        rsp.setRspDesc(errMsg);
        return rsp;
    }

    public static DcRspList createErrorRspList(String errMsg) {
        DcRspList rsp = new DcRspList();
        rsp.setRspCode("8888");
        rsp.setRspDesc(errMsg);
        return rsp;
    }

    public static DcRspList createErrorRspList(DcBusinessException e) {
        DcRspList rsp = new DcRspList();
        rsp.setRspCode(e.getErrorCode());
        rsp.setRspDesc(e.getMessage());
        return rsp;
    }
}

