/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.config;

import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.annotions.ParamNotEmpty;
import com.tydic.nicc.dc.base.annotions.ParamNotNull;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.exception.ParamCheckException;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class MethodParamFieldCheckAspect {
    private static final Logger log = LoggerFactory.getLogger(MethodParamFieldCheckAspect.class);

    @Around(value="@annotation(paramVerify)")
    public Object fieldNotEmptyVerify(ProceedingJoinPoint point, MethodParamVerifyEnable paramVerify) throws Throwable {
        Object[] requestParams = point.getArgs();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        String returnType = method.getReturnType().getTypeName();
        for (Object requestParamObj : requestParams) {
            Field[] declaredFields;
            for (Field field : declaredFields = requestParamObj.getClass().getDeclaredFields()) {
                String msg;
                ParamNotEmpty verify;
                field.setAccessible(true);
                Object fieldObj = field.get(requestParamObj);
                if (field.isAnnotationPresent(ParamNotEmpty.class)) {
                    verify = field.getAnnotation(ParamNotEmpty.class);
                    msg = verify.message();
                    if (StringUtils.isEmpty((CharSequence)msg)) {
                        msg = "\u5165\u53c2" + field.getName() + "\u4e0d\u5f97\u4e3a\u7a7a!";
                    }
                    if (fieldObj instanceof String) {
                        if (!StringUtils.isEmpty((CharSequence)String.valueOf(fieldObj))) continue;
                        if (Rsp.class.getName().equals(returnType)) {
                            return BaseRspUtils.createErrorRsp(msg);
                        }
                        if (RspList.class.getName().equals(returnType)) {
                            return BaseRspUtils.createErrorRspList(msg);
                        }
                        throw new ParamCheckException("6666", msg);
                    }
                    if (!Objects.isNull(fieldObj)) continue;
                    if (Rsp.class.getName().equals(returnType)) {
                        return BaseRspUtils.createErrorRsp(msg);
                    }
                    if (RspList.class.getName().equals(returnType)) {
                        return BaseRspUtils.createErrorRspList(msg);
                    }
                    throw new ParamCheckException("6666", msg);
                }
                if (!field.isAnnotationPresent(ParamNotNull.class)) continue;
                verify = field.getAnnotation(ParamNotNull.class);
                msg = verify.message();
                if (StringUtils.isEmpty((CharSequence)msg)) {
                    msg = "\u5165\u53c2" + field.getName() + "\u4e0d\u5f97\u4e3a\u7a7a!";
                }
                if (!Objects.isNull(fieldObj)) continue;
                if (Rsp.class.getName().equals(returnType)) {
                    return BaseRspUtils.createErrorRsp(msg);
                }
                if (RspList.class.getName().equals(returnType)) {
                    return BaseRspUtils.createErrorRspList(msg);
                }
                throw new ParamCheckException("6666", msg);
            }
        }
        return point.proceed();
    }
}

