/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.config;

import com.tydic.nicc.dc.boot.starter.config.RestTemplateConfigBean;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Resource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(value={"nicc-dc-config.rest.enable"}, matchIfMissing=true, havingValue="true")
@Configuration
public class RestTemplateConfig {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateConfig.class);
    @Resource
    private RestTemplateConfigBean restTemplateConfigBean;

    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }

    @Bean
    public ClientHttpRequestFactory componentsClientHttpRequestFactory() {
        try {
            HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
            factory.setReadTimeout(this.restTemplateConfigBean.getReadTimeout());
            factory.setConnectTimeout(this.restTemplateConfigBean.getConnectTimeout());
            if (this.restTemplateConfigBean.getTrustedAll().booleanValue()) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        return true;
                    }
                }).build();
                SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
                factory.setHttpClient((HttpClient)httpClient);
            }
            return factory;
        }
        catch (Exception e) {
            log.error("componentsClientHttpRequestFactory \u521b\u5efa\u5931\u8d25:{}", (Object)e.getMessage());
            System.exit(0);
            return null;
        }
    }
}

