/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.config.dubbo;

import com.tydic.nicc.dc.boot.starter.config.dubbo.Rest2DubboConfigPropertiesBean;
import com.tydic.nicc.dc.boot.starter.rest2dubbo.DubboApiFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"nicc-dc-config.rest-dubbo.enable"}, matchIfMissing=true, havingValue="true")
@Configuration
public class Rest2DubboAutoConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Rest2DubboAutoConfig.class);
    @Value(value="${dubbo.application.name}")
    private String applicationName;
    @Value(value="${dubbo.registry.address}")
    private String registryAddress;
    @Autowired
    private Rest2DubboConfigPropertiesBean rest2DubboConfigPropertiesBean;

    public void afterPropertiesSet() throws Exception {
        log.info("\u52a0\u8f7d Rest2Dubbo \u914d\u7f6e\u4fe1\u606f:{}", (Object)this.rest2DubboConfigPropertiesBean);
    }

    @Bean(value={"dubboApiFactory"})
    public DubboApiFactory createDubboApiFactory() throws IOException {
        return new DubboApiFactory(this.applicationName, this.registryAddress);
    }
}

