/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.config.servlet;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.tydic.nicc.dc.boot.starter.config.dubbo.Rest2DubboApiConfigBean;
import com.tydic.nicc.dc.boot.starter.config.dubbo.Rest2DubboConfigPropertiesBean;
import com.tydic.nicc.dc.boot.starter.config.dubbo.Rest2DubboServiceConfig;
import com.tydic.nicc.dc.boot.starter.rest2dubbo.DubboApiFactory;
import com.tydic.nicc.dc.boot.starter.rest2dubbo.Rest2DubboProxyService;
import com.tydic.nicc.dc.boot.starter.rest2dubbo.listener.Rest2DubboProcessListener;
import com.tydic.nicc.dc.boot.starter.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@ConditionalOnProperty(value={"nicc-dc-config.rest-dubbo.enable"}, matchIfMissing=true, havingValue="true")
@DependsOn(value={"dubboApiFactory"})
@Configuration
public class Rest2DubboServletProxyInit
implements ServletContextInitializer {
    private static final Logger log = LoggerFactory.getLogger(Rest2DubboServletProxyInit.class);
    @Autowired
    private Rest2DubboConfigPropertiesBean rest2DubboConfigPropertiesBean;
    @Autowired
    private DubboApiFactory dubboApiFactory;
    @Autowired(required=false)
    private List<Rest2DubboProcessListener> listeners;

    public void onStartup(ServletContext servletContext) {
        this.initRest2DubboConfig();
        if (this.rest2DubboConfigPropertiesBean.getServices() != null) {
            for (Rest2DubboApiConfigBean apiConfigBean : this.rest2DubboConfigPropertiesBean.getServices()) {
                if (apiConfigBean.getServiceMapping() == null || apiConfigBean.getServiceMapping().isEmpty()) {
                    log.warn("\u6ce8\u518c Rest2Dubbo servlet\u4ee3\u7406,\u8df3\u8fc7\u65e0\u6548\u914d\u7f6e:{}", (Object)apiConfigBean);
                    continue;
                }
                LinkedHashMap initParameters = new LinkedHashMap();
                Rest2DubboProxyService proxyServlet = new Rest2DubboProxyService(apiConfigBean, this.dubboApiFactory, this.listeners);
                ServletRegistration.Dynamic registration = servletContext.addServlet(apiConfigBean.getServlet(), (Servlet)proxyServlet);
                registration.addMapping(new String[]{apiConfigBean.getMapping() + "*"});
                registration.setInitParameters(initParameters);
                log.info("\u6ce8\u518c Rest2Dubbo servlet\u4ee3\u7406:{}:{} -> {}", new Object[]{apiConfigBean.getServlet(), apiConfigBean.getDesc(), apiConfigBean.getMapping()});
            }
        }
    }

    private void initRest2DubboConfig() {
        if (this.rest2DubboConfigPropertiesBean.getApiLoad().equals("local")) {
            if (this.rest2DubboConfigPropertiesBean.getServices().isEmpty()) {
                log.warn("\u672a\u914d\u7f6e Rest2Dubbo \u4ee3\u7406\u914d\u7f6e\u670d\u52a1\u5217\u8868!");
            } else {
                for (Rest2DubboApiConfigBean service : this.rest2DubboConfigPropertiesBean.getServices()) {
                    HashMap<String, Rest2DubboServiceConfig> serviceMapping = new HashMap<String, Rest2DubboServiceConfig>();
                    ArrayList<Rest2DubboServiceConfig> serviceConfigs = new ArrayList<Rest2DubboServiceConfig>();
                    try {
                        String serviceName = service.getName();
                        String servicePath = service.getPath();
                        if (!servicePath.endsWith("/")) {
                            servicePath = servicePath + "/";
                        }
                        if (servicePath.startsWith("classpath")) {
                            Object[] resources = new PathMatchingResourcePatternResolver().getResources(servicePath + serviceName);
                            log.info("\u52a0\u8f7d Rest2Dubbo \u670d\u52a1\u4ee3\u7406\u914d\u7f6e\u6587\u4ef6:{}", resources);
                            for (Object resource : resources) {
                                serviceConfigs.addAll(this.loadServiceJson(resource.getFile()));
                            }
                        }
                        if (servicePath.startsWith("/")) {
                            // empty if block
                        }
                        for (Rest2DubboServiceConfig serviceConfig : serviceConfigs) {
                            String Key = service.getMapping() + serviceConfig.getMapping();
                            serviceMapping.put(Key, serviceConfig);
                        }
                        service.setServiceMapping(serviceMapping);
                        log.info("{}", service.getServiceMapping());
                    }
                    catch (FileNotFoundException e) {
                        log.error("\u627e\u4e0d\u5230 Rest2Dubbo \u670d\u52a1\u4ee3\u7406\u914d\u7f6e\u6587\u4ef6:{}", (Object)e.getMessage());
                    }
                    catch (IOException e2) {
                        log.error("\u52a0\u8f7d Rest2Dubbo \u670d\u52a1\u4ee3\u7406\u914d\u7f6e\u6587\u4ef6\u9519\u8bef:{}", (Object)e2.getMessage());
                    }
                }
            }
        }
    }

    private List<Rest2DubboServiceConfig> loadServiceJson(File file) throws IOException {
        ArrayList<Rest2DubboServiceConfig> serviceConfigs = new ArrayList();
        String serviceJson = FileUtils.readFileContent(file);
        if (!JSONValidator.from((String)serviceJson).validate()) {
            log.error("Rest2Dubbo\u670d\u52a1\u5217\u8868\u6587\u4ef6\u914d\u7f6e\u9519\u8bef:{}", (Object)file.getAbsolutePath());
        } else {
            serviceConfigs = JSONObject.parseArray((String)serviceJson, Rest2DubboServiceConfig.class);
            log.info("\u52a0\u8f7dRest2Dubbo\u670d\u52a1\u5217\u8868\u6587\u4ef6:{}", (Object)serviceJson);
        }
        return serviceConfigs;
    }
}

