/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.http;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.config.RestTemplateConfigBean;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnProperty(value={"nicc-dc-config.rest.enable"}, matchIfMissing=true, havingValue="true")
@Component
public class RestApiHelper {
    private static final Logger log = LoggerFactory.getLogger(RestApiHelper.class);
    @Resource
    private RestTemplateConfigBean restTemplateConfigBean;
    @Resource
    private RestTemplate restTemplate;

    public String post(String url, String reqBody) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        return this.post(url, reqBody, headers, MediaType.APPLICATION_JSON);
    }

    public String post(String url, Object reqBody) {
        return this.post(url, JSONObject.toJSONString((Object)reqBody));
    }

    public String post(String url, String reqBody, HttpHeaders headers, MediaType ... mediaType) {
        URI uri = UriComponentsBuilder.fromUriString((String)url).build().toUri();
        RequestEntity requestEntity = ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).accept(mediaType)).headers(headers)).body((Object)reqBody);
        if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
            log.info("post \u8c03\u7528API:{}, header:{} ,Body:{}", new Object[]{url, requestEntity.getHeaders(), reqBody});
        }
        ResponseEntity exchange = this.restTemplate.exchange(requestEntity, String.class);
        String rspBody = (String)exchange.getBody();
        if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
            log.info("post \u8c03\u7528API,\u8fd4\u56de\u7ed3\u679c:{}", (Object)rspBody);
        }
        return rspBody;
    }

    public String post(String url, RequestEntity<String> requestEntity) {
        if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
            log.info("post \u8c03\u7528API:{},Body: {}", (Object)url, requestEntity.getBody());
        }
        ResponseEntity exchange = this.restTemplate.exchange(requestEntity, String.class);
        String rspBody = (String)exchange.getBody();
        if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
            log.info("post \u8c03\u7528API,\u8fd4\u56de\u7ed3\u679c:{}", (Object)rspBody);
        }
        return rspBody;
    }

    public String postForm(String url, MultiValueMap<String, String> params) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
            log.info("postForm \u8c03\u7528API:{},Body: {}", (Object)url, params);
        }
        String rspBody = (String)response.getBody();
        if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
            log.info("postForm \u8c03\u7528API:{},\u8fd4\u56de\u7ed3\u679c:{}", (Object)rspBody);
        }
        return rspBody;
    }

    public String get(String host, String pathAndQuery, Map<String, Object> params) {
        return this.get(host, pathAndQuery, params, null, null);
    }

    public String get(String host, String pathAndQuery, Map<String, Object> params, HttpHeaders headers, MediaType ... types) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(host + pathAndQuery));
        if (params != null) {
            params.forEach((key, value) -> builder.queryParam(key, new Object[]{value}));
        }
        try {
            ResponseEntity exchange;
            RequestEntity requestEntity = null;
            requestEntity = headers != null ? RequestEntity.get((URI)builder.build().toUri()).accept(types).headers(headers).build() : RequestEntity.get((URI)builder.build().toUri()).accept(types).build();
            if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
                log.info("get \u8c03\u7528API:{},url:{},requestEntity:{}", (Object)builder.build().toUri(), requestEntity.getBody());
            }
            if ((exchange = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.GET, (HttpEntity)requestEntity, String.class)).getStatusCode().is2xxSuccessful()) {
                String rspBody = (String)exchange.getBody();
                if (this.restTemplateConfigBean.getPrintLog().booleanValue()) {
                    log.info("get \u8c03\u7528API,\u8fd4\u56de\u7ed3\u679c:{}", (Object)rspBody);
                }
                return rspBody;
            }
        }
        catch (HttpClientErrorException e) {
            log.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:statusCode = {}, errMsg = {}", (Object)e.getStatusCode(), (Object)e.getMessage());
        }
        return "";
    }
}

