/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.tydic.nicc.dc.boot.starter.exception.DcOssException;
import com.tydic.nicc.dc.boot.starter.oss.OssConfigBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssFileUtil {
    private static final Logger log = LoggerFactory.getLogger(OssFileUtil.class);
    private static OSSClient ossClient;
    private static final String CONNECT_SERVER_ERROR = "\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01";
    private static final String CONNECT_CLIENT_ERROR = "\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01";

    private OssFileUtil() {
    }

    public static OSSClient getOssClient(OssConfigBean ossConfig) {
        if (ossClient == null) {
            ClientConfiguration conf = new ClientConfiguration();
            conf.setSupportCname(false);
            ossClient = new OSSClient(ossConfig.getEndpoint(), ossConfig.getAccesskey(), ossConfig.getAccessKeySecret(), conf);
        }
        return ossClient;
    }

    public static String uploadFile(File file, OssConfigBean ossConfig, String uploadPath) {
        String key = null;
        String fileName = file.getName();
        try (FileInputStream content = new FileInputStream(file);){
            OSSClient ossClient = OssFileUtil.getOssClient(ossConfig);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            PutObjectResult putResult = ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, (InputStream)content, meta);
            key = putResult.getETag();
        }
        catch (Exception e) {
            throw new DcOssException(CONNECT_CLIENT_ERROR, e.getMessage());
        }
        return key;
    }

    public static String uploadFileToOssByInputStream(String filePath, OssConfigBean ossConfig, InputStream inputStream) {
        String key = null;
        try {
            OSSClient ossClient = OssFileUtil.getOssClient(ossConfig);
            PutObjectResult putResult = ossClient.putObject(ossConfig.getBucketName(), filePath, inputStream);
            key = putResult.getETag();
        }
        catch (OSSException var4) {
            log.error(CONNECT_SERVER_ERROR, (Throwable)var4);
            throw new DcOssException("8888", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + var4.getMessage());
        }
        catch (ClientException var5) {
            throw new DcOssException("8888", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + var5.getMessage());
        }
        return key;
    }

    public static String uploadFileToOssByInputStream(String filePath, OssConfigBean ossConfig, String bucketName, InputStream inputStream) {
        String key = null;
        try {
            OSSClient ossClient = OssFileUtil.getOssClient(ossConfig);
            PutObjectResult putResult = ossClient.putObject(bucketName, filePath, inputStream);
            key = putResult.getETag();
        }
        catch (OSSException var4) {
            log.error(CONNECT_SERVER_ERROR, (Throwable)var4);
            throw new DcOssException("8888", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + var4.getMessage());
        }
        catch (ClientException var5) {
            log.error(CONNECT_CLIENT_ERROR, (Throwable)var5);
            throw new DcOssException("8888", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + var5.getMessage());
        }
        return key;
    }

    public static File downloadFile(String filePath, OssConfigBean ossConfig) {
        OSSClient ossClient = OssFileUtil.getOssClient(ossConfig);
        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf(46), filePath.length());
        String dir = System.getProperty("java.io.tmpdir");
        fileName = dir + File.separator + fileName;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        dirFile = new File(fileName);
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(ossConfig.getBucketName(), filePath);
            ossClient.getObject(getObjectRequest, dirFile);
            return dirFile;
        }
        catch (OSSException var7) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + fileName, (Throwable)var7);
            return null;
        }
    }

    public static InputStream downloadByInputStream(String filePath, OssConfigBean ossConfig) {
        InputStream in = null;
        OSSClient ossClient = OssFileUtil.getOssClient(ossConfig);
        try {
            OSSObject ossObject = ossClient.getObject(ossConfig.getBucketName(), filePath);
            in = ossObject.getObjectContent();
        }
        catch (OSSException var5) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath, (Throwable)var5);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String filePath, OssConfigBean ossConfig) {
        OSSClient ossClient = OssFileUtil.getOssClient(ossConfig);
        try {
            ossClient.deleteObject(ossConfig.getBucketName(), filePath);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    public static List<String> listObjects(OssConfigBean ossConfig, String prefix) {
        OSSClient ossClient = OssFileUtil.getOssClient(ossConfig);
        ObjectListing objectListing = ossClient.listObjects(ossConfig.getBucketName(), prefix);
        List sums = objectListing.getObjectSummaries();
        List<String> list = sums.stream().map(OSSObjectSummary::getKey).collect(Collectors.toList());
        return list;
    }

    public static String getcontentType(String FilenameExtension) {
        if (FilenameExtension.equalsIgnoreCase(".bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equalsIgnoreCase(".gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equalsIgnoreCase(".jpeg") || FilenameExtension.equalsIgnoreCase(".jpg") || FilenameExtension.equalsIgnoreCase(".png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equalsIgnoreCase(".html")) {
            return "text/html";
        }
        if (FilenameExtension.equalsIgnoreCase(".txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equalsIgnoreCase(".vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equalsIgnoreCase(".pptx") || FilenameExtension.equalsIgnoreCase(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equalsIgnoreCase(".docx") || FilenameExtension.equalsIgnoreCase(".doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equalsIgnoreCase(".xml")) {
            return "text/xml";
        }
        return "image/jpeg";
    }

    public static String getUrl(String filePath, String bucketName) {
        Date expiration = new Date(new Date().getTime() + 315360000000L);
        URL url = ossClient.generatePresignedUrl(bucketName, filePath, expiration);
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    public static String getUrl(String filePath, String bucketName, Date expiration) {
        URL url = ossClient.generatePresignedUrl(bucketName, filePath, expiration);
        if (url != null) {
            return url.toString();
        }
        return null;
    }
}

