/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.oss;

import com.tydic.nicc.dc.boot.starter.exception.DcOssException;
import com.tydic.nicc.dc.boot.starter.oss.OssConfigBean;
import com.tydic.nicc.dc.boot.starter.oss.OssFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class OssHelper {
    private static final String bucketNameImages = "service-images";
    private OssConfigBean ossConfig;

    public OssHelper(OssConfigBean ossConfig) {
        this.ossConfig = ossConfig;
    }

    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        String filePath = this.getFilePath(uploadFilePath, fileName);
        OssFileUtil.uploadFileToOssByInputStream(filePath, this.ossConfig, inputStream);
        return filePath;
    }

    public String uploadFileByFile(String uploadFilePath, String fileName, File file) {
        String filePath = this.getFilePath(uploadFilePath, fileName);
        try {
            OssFileUtil.uploadFileToOssByInputStream(filePath, this.ossConfig, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public File downloadToFile(String filePath) {
        return OssFileUtil.downloadFile(filePath, this.ossConfig);
    }

    public InputStream downLoadToInputStream(String filePath) {
        return OssFileUtil.downloadByInputStream(filePath, this.ossConfig);
    }

    public void deleteFile(String filePath) {
        OssFileUtil.deleteFile(filePath, this.ossConfig);
    }

    public List<String> listFile(String prefix) {
        return OssFileUtil.listObjects(this.ossConfig, prefix);
    }

    private final String getFilePath(String uploadFilePath, String fileName) {
        if (!uploadFilePath.endsWith("/")) {
            uploadFilePath = uploadFilePath + "/";
        }
        return uploadFilePath + fileName;
    }

    public String uploadImg(InputStream inputStream, String rootPath, String userId) {
        if (userId == null || "".equals(userId)) {
            throw new DcOssException("8888", "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff0c\u7528\u6237ID\u4e0d\u5f97\u4e3a\u7a7a\uff01");
        }
        String fileName = UUID.randomUUID().toString() + ".png";
        String filePath = this.getFilePath(rootPath, userId + "/" + fileName);
        OssFileUtil.uploadFileToOssByInputStream(filePath, this.ossConfig, inputStream);
        return filePath;
    }

    public String uploadPublicImg(InputStream inputStream, String rootPath, String userId) {
        if (userId == null || "".equals(userId)) {
            throw new DcOssException("8888", "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff0c\u7528\u6237ID\u4e0d\u5f97\u4e3a\u7a7a\uff01");
        }
        String fileName = UUID.randomUUID().toString() + ".png";
        String filePath = this.getFilePath(rootPath, userId + "/" + fileName);
        OssFileUtil.uploadFileToOssByInputStream(filePath, this.ossConfig, bucketNameImages, inputStream);
        return filePath;
    }

    public String getFileUrl(String filePath) {
        return OssFileUtil.getUrl(filePath, this.ossConfig.getBucketName());
    }

    public String getPublicImagesUrl(String filePath) {
        String[] urls = this.ossConfig.getEndpoint().split("//");
        return urls[0] + "//" + bucketNameImages + "." + urls[1] + "/" + filePath;
    }

    public String getFileUrl(String filePath, long exTime) {
        Date expiration = new Date(new Date().getTime() + exTime);
        return OssFileUtil.getUrl(filePath, this.ossConfig.getBucketName(), expiration);
    }
}

