/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.redis;

import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnProperty(value={"nicc-dc-config.redis.enable"}, matchIfMissing=true, havingValue="true")
@Component
public class RedisHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static final String RELEASE_LOCK_LUA_SCRIPT = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    private static final String LOCK_LUA_SCRIPT = "if redis.call('setNx',KEYS[1],ARGV[1]) then if redis.call('get',KEYS[1])==ARGV[1] then return redis.call('expire',KEYS[1],ARGV[2]) else return 0 end end";
    private static final Long EXEC_SCRIPT_SUCCESS = 1L;
    private static ThreadLocal<Thread> THREAD_LOCAL = new ThreadLocal();

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            this.logger.error("hasKey error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            this.logger.error("sGet error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            this.logger.error("sHasKey error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            this.logger.error("sSet error: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public long sSetByExpire(String key, long time, Object ... values) {
        long add = 0L;
        try {
            add = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
        }
        catch (Exception e) {
            this.logger.error("sSetByExpire error: {}", (Object)e.getMessage());
            return 0L;
        }
        return add;
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            this.logger.error("sSetAndTime error: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            this.logger.error("lGet error:", (Throwable)e);
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            this.logger.error("lGetListSize error: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            this.logger.error("lGetIndex error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            this.logger.error("lSet error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("lSet error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            this.logger.error("lSet error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lTrim(String key, long start, long end) {
        try {
            this.redisTemplate.opsForList().trim((Object)key, start, end);
            return true;
        }
        catch (Exception e) {
            this.logger.error("lTrim error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            this.logger.error("lUpdateIndex error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            this.logger.error("lRemove error: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public Object lLPop(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public Object lRPop(String key) {
        return this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public boolean lock(RedisLockEntity redisLockEntity, long tryLockSleep, long expTime) {
        if (expTime < 1L) {
            throw new DcBusinessException("\u53c2\u6570\u5f02\u5e38,\u9501\u7684\u5230\u671f\u65f6\u95f4\u4e0d\u5f97\u5c0f\u4e8e1s");
        }
        boolean locked = false;
        int tryCount = 3;
        while (!locked && tryCount > 0) {
            locked = this.lockLua(redisLockEntity, expTime);
            if (locked) continue;
            --tryCount;
            try {
                TimeUnit.MILLISECONDS.sleep(tryLockSleep);
            }
            catch (InterruptedException e) {
                this.logger.error("\u7ebf\u7a0b\u88ab\u4e2d\u65ad:" + Thread.currentThread().getId(), (Throwable)e);
            }
        }
        return locked;
    }

    public boolean lockLua(RedisLockEntity entity, long expireTime) {
        if (entity == null || entity.getLockKey() == null || entity.getRequestId() == null) {
            this.logger.warn("lua\u811a\u672c\u52a0\u9501\u5931\u8d25,\u53c2\u6570\u5f02\u5e38:{}", (Object)entity);
            return false;
        }
        if (expireTime < 1L) {
            throw new DcBusinessException("\u53c2\u6570\u5f02\u5e38,\u9501\u7684\u5230\u671f\u65f6\u95f4\u4e0d\u5f97\u5c0f\u4e8e1s");
        }
        try {
            DefaultRedisScript redisScript = new DefaultRedisScript(LOCK_LUA_SCRIPT, Long.class);
            Object result = this.redisTemplate.execute((RedisScript)redisScript, Collections.singletonList(entity.getLockKey()), new Object[]{entity.getRequestId(), expireTime});
            this.logger.debug("lua\u811a\u672c\u52a0\u9501\u7ed3\u679c:{}", result);
            return Objects.equals(result, EXEC_SCRIPT_SUCCESS);
        }
        catch (Exception e) {
            this.logger.error("lua\u811a\u672c\u52a0\u9501\u5931\u8d25:{},error:", (Object)entity, (Object)e);
            return false;
        }
    }

    public boolean lockRenew(RedisLockEntity lockEntity, long tryLockSleep, long expTime) {
        boolean locked = false;
        int tryCount = 3;
        while (!locked && tryCount > 0) {
            locked = this.lockLua(lockEntity, expTime);
            if (!locked) {
                --tryCount;
                try {
                    TimeUnit.MILLISECONDS.sleep(tryLockSleep);
                }
                catch (InterruptedException e) {
                    this.logger.error("\u7ebf\u7a0b\u88ab\u4e2d\u65ad:" + Thread.currentThread().getId(), (Throwable)e);
                }
                continue;
            }
            Thread renewal = new Thread(new RenewalLock(lockEntity, expTime));
            renewal.setDaemon(true);
            THREAD_LOCAL.set(renewal);
            renewal.start();
        }
        return locked;
    }

    public boolean lock(RedisLockEntity redisLockEntity, long tryLockSleepMill) {
        return this.lock(redisLockEntity, tryLockSleepMill, 10L);
    }

    public boolean lock(RedisLockEntity redisLockEntity) {
        return this.lock(redisLockEntity, 300L);
    }

    public boolean unlock(RedisLockEntity redisLockEntity) {
        if (redisLockEntity == null || redisLockEntity.getLockKey() == null || redisLockEntity.getRequestId() == null) {
            return false;
        }
        boolean releaseLock = false;
        String requestId = (String)this.redisTemplate.opsForValue().get((Object)redisLockEntity.getLockKey());
        if (redisLockEntity.getRequestId().equals(requestId)) {
            releaseLock = this.redisTemplate.delete((Object)redisLockEntity.getLockKey());
        }
        return releaseLock;
    }

    public boolean unlockLua(RedisLockEntity redisLockEntity) {
        if (redisLockEntity == null || redisLockEntity.getLockKey() == null || redisLockEntity.getRequestId() == null) {
            return false;
        }
        DefaultRedisScript redisScript = new DefaultRedisScript(RELEASE_LOCK_LUA_SCRIPT, Long.class);
        Long result = (Long)this.redisTemplate.execute((RedisScript)redisScript, Collections.singletonList(redisLockEntity.getLockKey()), new Object[]{redisLockEntity.getRequestId()});
        return Objects.equals(result, EXEC_SCRIPT_SUCCESS);
    }

    private class RenewalLock
    implements Runnable {
        private RedisLockEntity entity;
        private Long timeout;

        public RenewalLock(RedisLockEntity entity, Long timeout) {
            this.entity = entity;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        RedisHelper.this.logger.info("Redis\u7eed\u7b7e\u5b88\u62a4\u7ebf\u7a0b:{}", (Object)this.entity);
                        if (this.timeout > 3L) {
                            TimeUnit.SECONDS.sleep(this.timeout - 3L);
                        } else {
                            TimeUnit.SECONDS.sleep(this.timeout - 1L);
                        }
                        RedisHelper.this.redisTemplate.setEnableTransactionSupport(true);
                        RedisHelper.this.redisTemplate.watch((Object)this.entity.getLockKey());
                        String requestId = (String)RedisHelper.this.redisTemplate.opsForValue().get((Object)this.entity.getLockKey());
                        if (requestId != null && requestId.equals(this.entity.getRequestId())) {
                            RedisHelper.this.redisTemplate.multi();
                            RedisHelper.this.redisTemplate.expire((Object)this.entity.getLockKey(), this.timeout.longValue(), TimeUnit.SECONDS);
                            RedisHelper.this.redisTemplate.exec();
                        }
                        RedisHelper.this.redisTemplate.unwatch();
                    }
                }
                catch (InterruptedException e) {
                    RedisHelper.this.logger.error("Redis\u9501\u7eed\u7b7e\u5f02\u5e38,\u5b88\u62a4\u7ebf\u7a0b\u7eed\u7b7e\u4e2d\u65ad:", (Throwable)e);
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }
}

