/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.rest2dubbo;

import com.tydic.nicc.dc.boot.starter.rest2dubbo.bo.GenericInvokeBO;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboApiFactory {
    private static final Logger log = LoggerFactory.getLogger(DubboApiFactory.class);
    public static final String KEY_PARAM_TYPE = "ParamType";
    public static final String KEY_OBJECT = "Object";
    private ApplicationConfig application;
    private RegistryConfig registry;

    public DubboApiFactory(String appName, String address) {
        log.info("dubbo \u6cdb\u5316\u8c03\u7528  DubboApiFactory.init : appName = {},address = {}", (Object)appName, (Object)address);
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName(appName);
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setAddress(address);
        this.application = applicationConfig;
        this.registry = registryConfig;
    }

    public Object genericInvoke(GenericInvokeBO invokeBO) {
        log.info("dubbo \u6cdb\u5316\u8c03\u7528 : {}", (Object)invokeBO);
        List<Map<String, Object>> parameters = invokeBO.getParameters();
        ReferenceConfig reference = new ReferenceConfig();
        reference.setApplication(this.application);
        reference.setRegistry(this.registry);
        reference.setInterface(invokeBO.getApi());
        reference.setGeneric("true");
        reference.setGroup(invokeBO.getGroup());
        reference.setVersion(invokeBO.getVersion());
        ReferenceConfigCache cache = ReferenceConfigCache.getCache();
        GenericService genericService = (GenericService)cache.get((ReferenceConfigBase)reference);
        int len = parameters.size();
        String[] invokeParamTypes = new String[len];
        Object[] invokeParams = new Object[len];
        for (int i = 0; i < len; ++i) {
            invokeParamTypes[i] = String.valueOf(parameters.get(i).get(KEY_PARAM_TYPE));
            invokeParams[i] = parameters.get(i).get(KEY_OBJECT);
        }
        Object response = genericService.$invoke(invokeBO.getMethod(), invokeParamTypes, invokeParams);
        return response;
    }
}

