/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.rest2dubbo;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.eum.Rest2DubboProxyErrCode;
import com.tydic.nicc.dc.boot.starter.config.dubbo.Rest2DubboApiConfigBean;
import com.tydic.nicc.dc.boot.starter.config.dubbo.Rest2DubboServiceConfig;
import com.tydic.nicc.dc.boot.starter.rest2dubbo.DubboApiFactory;
import com.tydic.nicc.dc.boot.starter.rest2dubbo.bo.GenericInvokeBO;
import com.tydic.nicc.dc.boot.starter.rest2dubbo.listener.Rest2DubboProcessListener;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class Rest2DubboProxyService
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(Rest2DubboProxyService.class);
    protected Rest2DubboApiConfigBean apiConfigBean;
    protected DubboApiFactory apiFactory;
    protected List<Rest2DubboProcessListener> listeners;

    public Rest2DubboProxyService(Rest2DubboApiConfigBean apiConfigBean, DubboApiFactory apiFactory, List<Rest2DubboProcessListener> listeners) {
        this.apiConfigBean = apiConfigBean;
        this.apiFactory = apiFactory;
        this.listeners = listeners;
        if (this.listeners == null) {
            this.listeners = new ArrayList<Rest2DubboProcessListener>();
        } else {
            this.listeners.sort(Comparator.comparing(Rest2DubboProcessListener::order));
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        log.info("{} \u521d\u59cb\u5316\u5b8c\u6210 serviceMapping:{}", (Object)servletConfig.getServletName(), this.apiConfigBean.getServiceMapping());
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        Rest2DubboServiceConfig serviceConfig;
        HttpServletResponse response;
        String errReason;
        int errorCode;
        block16: {
            errorCode = 0;
            errReason = "";
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            response = (HttpServletResponse)servletResponse;
            String queryString = request.getQueryString();
            String requestUri = request.getRequestURI();
            String method = request.getMethod();
            for (Rest2DubboProcessListener rest2DubboProcessListener : this.listeners) {
                rest2DubboProcessListener.onBefore(request, this.apiConfigBean);
            }
            log.info("Rest2Dubbo \u4ee3\u7406\u8bf7\u6c42:[{}],[{}],[{}]", new Object[]{method, requestUri, queryString});
            serviceConfig = this.apiConfigBean.getServiceMapping().get(requestUri);
            if (this.apiFactory == null && serviceConfig == null) {
                errorCode = Rest2DubboProxyErrCode.UNKNOW_DUBBO_SERVICE.getCode();
                errReason = "Rest2Dubbo \u672a\u5339\u914d\u5230\u670d\u52a1,\u8bf7\u68c0\u67e5\u670d\u52a1\u5217\u8868\u914d\u7f6e\u4fe1\u606f: mapping = " + requestUri;
                log.error("Rest2Dubbo \u672a\u5339\u914d\u5230\u670d\u52a1:requestUri = {}", (Object)requestUri);
                this.invokeError(response, errReason);
                for (Rest2DubboProcessListener listener : this.listeners) {
                    listener.onError(errorCode, errReason, serviceConfig, this.apiFactory);
                }
                return;
            }
            GenericInvokeBO genericInvokeBO = GenericInvokeBO.builder().api(serviceConfig.getApi()).group(serviceConfig.getGroup()).version(serviceConfig.getVersion()).method(serviceConfig.getMethod()).paramClass(serviceConfig.getParamClass()).build();
            if (method.equals(RequestMethod.GET.name())) {
                Map<String, Object> param = this.getParameterMap(request);
                List<Map<String, Object>> invokeParams = this.parseDubboInvokeParams(param);
                genericInvokeBO.setParameters(invokeParams);
            } else if (method.equals(RequestMethod.POST.name())) {
                String body = Rest2DubboProxyService.readRequestBody(request);
                if (JSONValidator.from((String)body).validate() && StringUtils.isNotEmpty((CharSequence)genericInvokeBO.getParamClass())) {
                    Map reqData = (Map)JSONObject.parseObject((String)body, Map.class);
                    LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
                    param.put("ParamType", genericInvokeBO.getParamClass());
                    param.put("Object", reqData);
                    ArrayList<Map<String, Object>> invokeParams = new ArrayList<Map<String, Object>>();
                    invokeParams.add(param);
                    genericInvokeBO.setParameters(invokeParams);
                } else {
                    log.warn("\u53c2\u6570\u4e0d\u652f\u6301,\u8bf7\u4f20\u5165json\u683c\u5f0f\u5165\u53c2,\u5e76\u914d\u7f6e\u5bf9\u5e94\u65b9\u6cd5\u53c2\u6570\u7c7b\u540d\u79f0: mapping = {},reqBody = {}", (Object)requestUri, (Object)body);
                    errorCode = Rest2DubboProxyErrCode.PARAM_ERROR.getCode();
                    errReason = "\u53c2\u6570\u9519\u8bef,\u8bf7\u4f20\u5165json\u683c\u5f0f\u5165\u53c2,\u5e76\u914d\u7f6e\u5bf9\u5e94\u65b9\u6cd5\u53c2\u6570\u7c7b\u540d\u79f0: mapping = " + requestUri;
                }
            } else {
                errorCode = Rest2DubboProxyErrCode.REQUEST_METHOD_ERROR.getCode();
                errReason = "\u8bf7\u6c42\u7c7b\u578b\u4e0d\u652f\u6301,\u5f53\u524d\u4ec5\u652f\u6301GET/POST\u8bf7\u6c42\u7c7b\u578b: method = " + method + ", mapping = " + requestUri;
            }
            if (errorCode == 0) {
                try {
                    Object invokeRsp = this.apiFactory.genericInvoke(genericInvokeBO);
                    this.printRspValue(response, invokeRsp);
                    for (Rest2DubboProcessListener listener : this.listeners) {
                        listener.onAfter(genericInvokeBO, serviceConfig, this.apiFactory);
                    }
                }
                catch (Exception e) {
                    errorCode = Rest2DubboProxyErrCode.RPC_ERROR.getCode();
                    errReason = "dubbo\u6cdb\u5316\u8c03\u7528\u5f02\u5e38:" + e.getMessage();
                    log.error("dubbo\u6cdb\u5316\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
                    if (errReason.contains("No provider available")) {
                        errReason = "dubbo\u6cdb\u5316\u8c03\u7528\u5f02\u5e38: \u670d\u52a1[" + genericInvokeBO.getFullServiceName() + "]\u672a\u6ce8\u518c,\u8bf7\u68c0\u67e5\u914d\u7f6e!";
                    }
                    if (!errReason.contains("Failed to invoke the method")) break block16;
                    errReason = "dubbo\u6cdb\u5316\u8c03\u7528\u5f02\u5e38: \u670d\u52a1[" + genericInvokeBO.getFullServiceName() + "]\u8c03\u7528\u5931\u8d25,\u8bf7\u68c0\u67e5\u65b9\u6cd5!";
                }
            }
        }
        if (errorCode > 0) {
            this.invokeError(response, errReason);
            for (Rest2DubboProcessListener listener : this.listeners) {
                listener.onError(errorCode, errReason, serviceConfig, this.apiFactory);
            }
        }
    }

    public String getServletInfo() {
        return "A proxy rest2dubbo servlet by Chenwk, chenwk@tydic.com";
    }

    public void destroy() {
        super.destroy();
    }

    private List<Map<String, Object>> parseDubboInvokeParams(Map<String, Object> pramMap) {
        ArrayList<Map<String, Object>> invokePrams = new ArrayList<Map<String, Object>>();
        if (!pramMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : pramMap.entrySet()) {
                LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
                if (entry.getValue() instanceof Integer) {
                    param.put("ParamType", "java.lang.Integer");
                } else if (entry.getValue() instanceof Long) {
                    param.put("ParamType", "java.lang.Long");
                } else if (entry.getValue() instanceof Float) {
                    param.put("ParamType", "java.lang.Float");
                } else if (entry.getValue() instanceof Double) {
                    param.put("ParamType", "java.lang.Double");
                } else if (entry.getValue() instanceof Boolean) {
                    param.put("ParamType", "java.lang.Boolean");
                } else {
                    param.put("ParamType", "java.lang.String");
                }
                param.put("Object", entry.getValue());
                invokePrams.add(param);
            }
        }
        return invokePrams;
    }

    private Map<String, Object> getParameterMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        log.info("request \u83b7\u53d6\u5230\u53c2\u6570:{}", (Object)properties);
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
        Iterator entries = properties.entrySet().iterator();
        String name = "";
        String value = "";
        Object valueObj = null;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readRequestBody(HttpServletRequest request) {
        int len = request.getContentLength();
        byte[] buffer = new byte[len];
        ServletInputStream in = null;
        try {
            in = request.getInputStream();
            in.read(buffer, 0, len);
            in.close();
            String string = new String(buffer, "UTF-8");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private void printRspValue(HttpServletResponse response, Object object) {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            response.getWriter().write(JSONObject.toJSONString((Object)object));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void invokeError(HttpServletResponse response, String msg) {
        Rsp rsp = BaseRspUtils.createErrorRsp("9999", msg);
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            response.getWriter().write(JSONObject.toJSONString((Object)rsp));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

