/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static List<List<String>> splitList(List<String> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<String> subList = list.subList(i * len, (i + 1) * len > size ? size : len * (i + 1));
            result.add(subList);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileContent(InputStream inputStream) throws IOException {
        BufferedReader reader = null;
        StringBuffer sbf = new StringBuffer();
        try {
            String tempStr;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr);
            }
            reader.close();
            String string = sbf.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileContent(File file) throws IOException {
        BufferedReader reader = null;
        StringBuffer sbf = new StringBuffer();
        try {
            String tempStr;
            reader = new BufferedReader(new FileReader(file));
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr);
            }
            reader.close();
            String string = sbf.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String readFileContent(String filePath) throws IOException {
        return FileUtils.readFileContent(new File(filePath));
    }

    public static InputStream getFileInputStreamFromResourceDir(String sourceDir, String fileName) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        InputStream stream = null;
        try {
            Resource[] resources = resolver.getResources(sourceDir + "/*");
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                try {
                    File file = resource.getFile();
                    if (!file.isFile() || !file.getName().contains(fileName)) continue;
                    stream = resource.getInputStream();
                    continue;
                }
                catch (IOException e) {
                    logger.warn("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff0c\u5982\u679c\u4e3ajar\u5305\u8fd0\u884c\uff0c\u5ffd\u7565\u8be5\u8b66\u544a\uff01:{}", (Object)e.getMessage());
                    stream = resource.getInputStream();
                }
            }
        }
        catch (IOException e) {
            logger.warn("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef:", (Throwable)e);
        }
        return stream;
    }

    public static String getFileContentFromResourceDir(String sourceDir, String fileName) {
        InputStream in = FileUtils.getFileInputStreamFromResourceDir(sourceDir, fileName);
        StringBuffer content = new StringBuffer();
        try {
            if (in != null) {
                byte[] bytes = new byte[256];
                int len = 0;
                while ((len = in.read(bytes)) != -1) {
                    String str = new String(bytes, 0, len);
                    content.append(str);
                }
            }
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef:", (Throwable)e);
        }
        return content.toString();
    }
}

