/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.boot.starter.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.tydic.nicc.dc.base.bo.jwt.PayLoadBaseInfo;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTUtils {
    private static final Logger log = LoggerFactory.getLogger(JWTUtils.class);
    private static final String SECRET = "010.Tydic!";
    private static final String ISS_USER = "jwt.auth";
    private static final String ID_CLAIM = "id";
    public static final String LOGIN_INFO = "LOGIN_INFO";
    private static final long EXPIRE_TIME = 0x6DDD00L;

    public static String sign(PayLoadBaseInfo playLoad) {
        Algorithm algorithm = Algorithm.HMAC256((String)SECRET);
        if (playLoad.getExp() == null) {
            playLoad.setExp(Long.valueOf(System.currentTimeMillis() + 0x6DDD00L));
        }
        if (playLoad.getUserId() == null) {
            log.error("\u751f\u6210token\u5931\u8d25\uff0cuserId\u4e0d\u5f97\u4e3a\u7a7a\uff01");
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)playLoad.getLoginInfo())) {
            log.error("\u751f\u6210token\u5931\u8d25\uff0c\u767b\u5f55\u4fe1\u606f\u4e0d\u5f97\u4e3a\u7a7a\uff01");
        }
        String token = JWT.create().withIssuer(ISS_USER).withIssuedAt(new Date(System.currentTimeMillis())).withExpiresAt(new Date(playLoad.getExp())).withClaim(LOGIN_INFO, playLoad.getLoginInfo()).withClaim(ID_CLAIM, playLoad.getUserId()).sign(algorithm);
        return token;
    }

    public static boolean verifyToken(String token) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).withIssuer(new String[]{ISS_USER}).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException e) {
            log.error("verifyToken \u6821\u9a8ctoken\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static DecodedJWT verifyAndReturn(String token) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).withIssuer(new String[]{ISS_USER}).build();
            return verifier.verify(token);
        }
        catch (JWTVerificationException e) {
            log.error("verifyAndReturn \u6821\u9a8ctoken\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String verifyAndReturnUserType(String token) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).withIssuer(new String[]{ISS_USER}).build();
            return verifier.verify(token).getClaim("userType").asString();
        }
        catch (JWTVerificationException e) {
            log.error("verifyAndReturn \u6821\u9a8ctoken\u5931\u8d25\uff1a{},userId = {}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verify(String token, Integer userId) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).withIssuer(new String[]{ISS_USER}).withClaim(ID_CLAIM, userId).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException e) {
            log.error("verify \u6821\u9a8ctoken\u5931\u8d25\uff1a{},id = {}", (Object)e.getMessage(), (Object)userId);
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim(ID_CLAIM).asString();
        }
        catch (JWTDecodeException e) {
            log.error("\u83b7\u53d6\u7528\u6237id\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getIssuedDate(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getIssuedAt();
        }
        catch (JWTDecodeException e) {
            log.error("\u83b7\u53d6\u9881\u53d1\u65f6\u95f4\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getExpireDate(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getExpiresAt();
        }
        catch (JWTDecodeException e) {
            log.error("\u83b7\u53d6\u8fc7\u671f\u65f6\u95f4\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isExpire(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getExpiresAt().compareTo(new Date()) <= 0;
        }
        catch (JWTDecodeException e) {
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String getLoginInfo(String token) {
        DecodedJWT decodedJWT = JWTUtils.verifyAndReturn(token);
        if (decodedJWT != null) {
            return decodedJWT.getClaim(LOGIN_INFO).asString();
        }
        throw new RuntimeException("Token\u6821\u9a8c\u5931\u8d25\uff01");
    }

    public static String createJwtToken(String userId, String loginInfo) {
        return JWTUtils.createJwtToken(userId, loginInfo, 0x6DDD00L);
    }

    public static String createJwtToken(String userId, String loginInfo, Long extTime) {
        PayLoadBaseInfo payLoadInfo = new PayLoadBaseInfo();
        payLoadInfo.setUserId(userId);
        payLoadInfo.setLoginInfo(loginInfo);
        Long exp = System.currentTimeMillis() + extTime;
        payLoadInfo.setExp(exp);
        String token = JWTUtils.sign(payLoadInfo);
        if ("".equals(token)) {
            throw new RuntimeException("\u767b\u5f55\u5931\u8d25,token\u521b\u5efa\u5931\u8d25\uff01");
        }
        return token;
    }
}

